/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls.producer;

import com.volcengine.model.tls.ClientConfig;
import com.volcengine.model.tls.exception.LogException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProducerConfig {
    public static final int DEFAULT_TOTAL_SIZE_IN_BYTES = 0x6400000;
    public static final int DEFAULT_MAX_THREAD_COUNT = 50;
    public static final int DEFAULT_MAX_BATCH_SIZE = 524288;
    public static final int MAX_BATCH_SIZE = 0xA00000;
    public static final int DEFAULT_MAX_BATCH_COUNT = 4096;
    public static final int MAX_BATCH_COUNT = 32768;
    public static final int MAX_LOG_GROUP_COUNT = 10000;
    public static final int DEFAULT_LINGER_MS = 2000;
    public static final int TOO_MANY_REQUEST_ERROR = 429;
    public static final int EXTERNAL_ERROR = 500;
    public static final int MIN_WAIT_MS = 100;
    public static final int DEFAULT_RETRY_COUNT = 10;
    public static final int DEFAULT_RESERVED_ATTEMPTS = 11;
    public static final int MAX_RETRY_COUNT = 4;
    public static final int MAX_RESERVED_ATTEMPTS = 5;
    public static final int AVAILABLE_PROCESSORS;
    public static final int MAX_THREAD_COUNT;
    public static final int DEFAULT_SHARD_COUNT = 2;
    public static final long DEFAULT_BLOCK_MS = 60000L;
    private int totalSizeInBytes = 0x6400000;
    private int maxThreadCount = MAX_THREAD_COUNT;
    private int maxBatchSizeBytes = 524288;
    private int maxBatchCount = 4096;
    private int lingerMs = 2000;
    private long maxBlockMs = 60000L;
    private int retryCount = 10;
    private int maxReservedAttempts = 11;
    private ClientConfig clientConfig;
    private int shardCount = 2;
    private static final Log log;

    public ProducerConfig(String endpoint, String region, String accessKey, String accessSecret, String token) {
        this.clientConfig = new ClientConfig(endpoint, region, accessKey, accessSecret, token);
    }

    public ProducerConfig(String endpoint, String region, String accessKey, String accessSecret) {
        this(endpoint, region, accessKey, accessSecret, null);
    }

    public static boolean needRetry(int httpCode) {
        return httpCode == 429 || httpCode >= 500 || httpCode == 0;
    }

    public void validConfig() throws LogException {
        this.totalSizeInBytes = (int)this.validNumber(this.totalSizeInBytes, 1, Integer.MAX_VALUE, 0x6400000);
        this.maxThreadCount = (int)this.validNumber(this.maxThreadCount, 1, MAX_THREAD_COUNT, MAX_THREAD_COUNT);
        this.maxBatchSizeBytes = (int)this.validNumber(this.maxBatchSizeBytes, 1, 0xA00000, 524288);
        this.maxBatchCount = (int)this.validNumber(this.maxBatchCount, 1, 32768, 4096);
        this.lingerMs = (int)this.validNumber(this.lingerMs, 100, Integer.MAX_VALUE, 2000);
        this.maxBlockMs = this.validNumber(this.maxBlockMs, 0, Integer.MAX_VALUE, 60000L);
        this.retryCount = (int)this.validNumber(this.retryCount, 1, 4, 10);
        this.maxReservedAttempts = (int)this.validNumber(this.maxReservedAttempts, 2, 5, 11);
        this.shardCount = (int)this.validNumber(this.shardCount, 1, Integer.MAX_VALUE, 2);
        if (this.clientConfig == null || StringUtils.isEmpty((CharSequence)this.clientConfig.getEndpoint()) || StringUtils.isEmpty((CharSequence)this.clientConfig.getAccessKeyId()) || StringUtils.isEmpty((CharSequence)this.clientConfig.getAccessKeySecret()) || StringUtils.isEmpty((CharSequence)this.clientConfig.getRegion())) {
            throw new LogException("InvalidArgument", String.valueOf(this.clientConfig), null);
        }
    }

    private long validNumber(Number field, Number min, Number max, Number originDefault) {
        long fieldValue = Long.parseLong(String.valueOf(field));
        long minValue = Long.parseLong(String.valueOf(min));
        long maxValue = Long.parseLong(String.valueOf(max));
        long defaultValue = Long.parseLong(String.valueOf(originDefault));
        if (fieldValue > maxValue || fieldValue < minValue) {
            return defaultValue;
        }
        return fieldValue;
    }

    public void setTotalSizeInBytes(int totalSizeInBytes) throws LogException {
        if (totalSizeInBytes <= 0) {
            throw new LogException("InvalidArgument", "totalSizeInBytes must be greater than zero,actual:" + totalSizeInBytes, null);
        }
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public void setMaxThreadCount(int maxThreadCount) throws LogException {
        if (maxThreadCount <= 0 || maxThreadCount > MAX_THREAD_COUNT) {
            throw new LogException("InvalidArgument", String.format("maxThreadCount must between 1 to %d,actual:%d", MAX_THREAD_COUNT, maxThreadCount), null);
        }
        this.maxThreadCount = maxThreadCount;
    }

    public void setMaxBatchSizeBytes(int maxBatchSizeBytes) throws LogException {
        if (maxBatchSizeBytes <= 0 || maxBatchSizeBytes > 0xA00000) {
            throw new LogException("InvalidArgument", String.format("maxBatchSizeBytes must between 1 to %d,actual:%d", 0xA00000, maxBatchSizeBytes), null);
        }
        this.maxBatchSizeBytes = maxBatchSizeBytes;
    }

    public void setMaxBatchCount(int maxBatchCount) throws LogException {
        if (maxBatchCount <= 0 || maxBatchCount > 32768) {
            throw new LogException("InvalidArgument", String.format("maxBatchCount must between 1 to %d,actual:%d", 32768, maxBatchCount), null);
        }
        this.maxBatchCount = maxBatchCount;
    }

    public void setLingerMs(int lingerMs) throws LogException {
        if (lingerMs < 100) {
            throw new LogException("InvalidArgument", String.format("maxWaitMs must be greater than %d,actual:%d", 100, this.totalSizeInBytes), null);
        }
        this.lingerMs = lingerMs;
    }

    public void setRetryCount(int retryCount) throws LogException {
        if (retryCount <= 0 || retryCount > 4) {
            throw new LogException("InvalidArgument", String.format("retryCount must between 1 to %d,actual:%d", 4, retryCount), null);
        }
        this.retryCount = retryCount;
    }

    public void setMaxReservedAttempts(int maxReservedAttempts) throws LogException {
        if (maxReservedAttempts < 2 || maxReservedAttempts > 5) {
            throw new LogException("InvalidArgument", String.format("maxReservedAttempts must between 2 to %d,actual:%d", 5, maxReservedAttempts), null);
        }
        this.maxReservedAttempts = maxReservedAttempts;
    }

    public void setClientConfig(ClientConfig clientConfig) throws LogException {
        if (clientConfig == null || StringUtils.isEmpty((CharSequence)clientConfig.getEndpoint()) || StringUtils.isEmpty((CharSequence)clientConfig.getAccessKeyId()) || StringUtils.isEmpty((CharSequence)clientConfig.getAccessKeySecret()) || StringUtils.isEmpty((CharSequence)clientConfig.getRegion())) {
            throw new LogException("InvalidArgument", String.valueOf(clientConfig), null);
        }
        this.clientConfig = clientConfig;
    }

    public void setShardCount(int shardCount) throws LogException {
        if (shardCount <= 0) {
            throw new LogException("InvalidArgument", "shardCount must be greater than zero,actual:" + shardCount, null);
        }
        this.shardCount = shardCount;
    }

    public void setMaxBlockMs(long maxBlockMs) throws LogException {
        if (maxBlockMs <= 0L) {
            throw new LogException("InvalidArgument", "maxBlockMs must be greater than zero,actual:" + maxBlockMs, null);
        }
        this.maxBlockMs = maxBlockMs;
    }

    public void checkBatchSize(int batchSize) throws LogException {
        if (batchSize > 0xA00000) {
            throw new LogException("Invalid Arguments", "log batch size " + batchSize + " is larger than MAX_BATCH_SIZE " + 0xA00000, null);
        }
        if (batchSize > this.getTotalSizeInBytes()) {
            throw new LogException("Invalid Arguments", "log batch size " + batchSize + " is larger than DEFAULT_TOTAL_SIZE_IN_BYTES " + 0x6400000, null);
        }
    }

    public int getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public int getMaxBatchSizeBytes() {
        return this.maxBatchSizeBytes;
    }

    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    public int getLingerMs() {
        return this.lingerMs;
    }

    public long getMaxBlockMs() {
        return this.maxBlockMs;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getMaxReservedAttempts() {
        return this.maxReservedAttempts;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public String toString() {
        return "ProducerConfig(totalSizeInBytes=" + this.getTotalSizeInBytes() + ", maxThreadCount=" + this.getMaxThreadCount() + ", maxBatchSizeBytes=" + this.getMaxBatchSizeBytes() + ", maxBatchCount=" + this.getMaxBatchCount() + ", lingerMs=" + this.getLingerMs() + ", maxBlockMs=" + this.getMaxBlockMs() + ", retryCount=" + this.getRetryCount() + ", maxReservedAttempts=" + this.getMaxReservedAttempts() + ", clientConfig=" + this.getClientConfig() + ", shardCount=" + this.getShardCount() + ")";
    }

    static {
        MAX_THREAD_COUNT = AVAILABLE_PROCESSORS = Math.max(Runtime.getRuntime().availableProcessors(), 1);
        log = LogFactory.getLog(ProducerConfig.class);
    }
}

