/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.interceptor;

import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.volcengine.ApiException;
import com.volcengine.Pair;
import com.volcengine.ProgressRequestBody;
import com.volcengine.auth.CredentialProvider;
import com.volcengine.auth.CredentialValue;
import com.volcengine.interceptor.InterceptorContext;
import com.volcengine.interceptor.RequestInterceptor;
import com.volcengine.sign.Credentials;
import com.volcengine.sign.ServiceInfo;
import com.volcengine.sign.VolcstackSign;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.commons.lang.StringUtils;

public class SignRequestInterceptor
implements RequestInterceptor {
    public static String name = "volcengine-sign-request-interceptor";

    @Override
    public String name() {
        return name;
    }

    @Override
    public InterceptorContext intercept(InterceptorContext context) throws ApiException {
        String path = context.getRequestContext().getPath();
        String method = context.getRequestContext().getMethod();
        Map<String, String> headerParams = context.getRequestContext().getHeaderParams();
        List<Pair> queryParams = context.getRequestContext().getQueryParams();
        ServiceInfo serviceInfo = context.getRequestContext().getServiceInfo();
        String[] authNames = context.getRequestContext().getAuthNames();
        RequestBody reqBody = context.getRequestContext().getRequestBody();
        ProgressRequestBody.ProgressRequestListener progressRequestListener = context.getInitInterceptorContext().getProgressRequestListener();
        Buffer buffer = new Buffer();
        try {
            if (reqBody != null) {
                reqBody.writeTo((BufferedSink)buffer);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        VolcstackSign volcengineSign = new VolcstackSign();
        if (context.getApiClient().getCredentials() != null) {
            volcengineSign.setCredentials(context.getApiClient().getCredentials());
        } else {
            CredentialProvider credentialProvider = context.getApiClient().getCredentialProvider();
            if (credentialProvider == null) {
                throw new ApiException("one of credentials and credentialProvider must set");
            }
            CredentialValue credentialValue = credentialProvider.get();
            if (credentialValue == null) {
                throw new ApiException("credentialProvider return null");
            }
            Credentials credentials = Credentials.getCredentials(credentialValue.getAk(), credentialValue.getSk(), credentialValue.getSessionToken());
            volcengineSign.setCredentials(credentials);
        }
        volcengineSign.setRegion(context.getApiClient().getRegion());
        volcengineSign.setService(serviceInfo.getServiceName());
        volcengineSign.setMethod(serviceInfo.getMethod().toUpperCase());
        if (volcengineSign.getCredentials() == null) {
            throw new RuntimeException("Credentials must set when ApiClient init");
        }
        if (StringUtils.isEmpty((String)volcengineSign.getCredentials().getAccessKey()) || StringUtils.isEmpty((String)volcengineSign.getCredentials().getSecretKey())) {
            throw new RuntimeException("AccessKey and SecretKey must set when ApiClient init Credentials");
        }
        if (StringUtils.isEmpty((String)volcengineSign.getRegion())) {
            throw new RuntimeException("Region must set when ApiClient init");
        }
        volcengineSign.applyToParams(queryParams, headerParams, buffer.readUtf8());
        StringBuilder url = new StringBuilder();
        url.append(context.getRequestContext().getSchema());
        url.append("://");
        url.append(context.getRequestContext().getHost());
        url.append(path);
        context.getApiClient().buildQueryParams(path, url, queryParams);
        Request.Builder reqBuilder = new Request.Builder().url(url.toString());
        for (Map.Entry entry : headerParams.entrySet()) {
            reqBuilder.header((String)entry.getKey(), context.getApiClient().parameterToString(entry.getValue()));
        }
        Request request = null;
        if (progressRequestListener != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody(reqBody, progressRequestListener);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        context.getRequestContext().setRequest(request);
        return context;
    }
}

