/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.auth.filter;

import com.xxl.sso.core.helper.XxlSsoHelper;
import com.xxl.sso.core.model.LoginInfo;
import com.xxl.sso.core.path.impl.AntPathMatcher;
import com.xxl.tool.core.StringTool;
import com.xxl.tool.gson.GsonTool;
import com.xxl.tool.response.Response;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlSsoNativeFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(XxlSsoNativeFilter.class);
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final String excludedPaths;

    public XxlSsoNativeFilter(String excludedPaths) {
        this.excludedPaths = excludedPaths;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        logger.info("XxlSsoNativeFilter init.");
    }

    private boolean isMatchExcludedPaths(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (StringTool.isNotBlank((String)this.excludedPaths)) {
            for (String excludedPath : this.excludedPaths.split(",")) {
                String uriPattern = excludedPath.trim();
                if (StringTool.isBlank((String)uriPattern) || !this.antPathMatcher.match(uriPattern, servletPath)) continue;
                return true;
            }
        }
        return false;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.isMatchExcludedPaths(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Response<LoginInfo> loginCheckResult = XxlSsoHelper.loginCheckWithHeader(request);
        LoginInfo loginInfo = null;
        if (loginCheckResult != null && loginCheckResult.isSuccess()) {
            loginInfo = (LoginInfo)loginCheckResult.getData();
        }
        if (loginInfo == null) {
            String loginFailMsg = GsonTool.toJson((Object)Response.of((int)301, (String)("not login for path:" + request.getServletPath())));
            response.setStatus(200);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().println(loginFailMsg);
            return;
        }
        request.setAttribute("xxl_sso_user", loginInfo);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

