/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.auth.credentials.YopCredentials;
import com.yeepay.yop.sdk.base.cache.YopCredentialsCache;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParserFactory;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.enums.CertStoreType;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.model.cert.YopPlatformCertQueryResult;
import com.yeepay.yop.sdk.model.cert.YopPlatformPlainCert;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import com.yeepay.yop.sdk.security.cert.YopPublicKey;
import com.yeepay.yop.sdk.service.common.request.YopRequest;
import com.yeepay.yop.sdk.service.common.response.YopResponse;
import com.yeepay.yop.sdk.utils.ClientUtils;
import com.yeepay.yop.sdk.utils.EnvUtils;
import com.yeepay.yop.sdk.utils.JsonUtils;
import com.yeepay.yop.sdk.utils.X509CertUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopCertificateCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopCertificateCache.class);
    private static final String CERT_DOWNLOAD_API_URI = "/rest/v2.0/yop/platform/certs";
    private static final String CERT_DOWNLOAD_API_METHOD = "GET";
    private static final String CERT_DOWNLOAD_API_SECURITY = "YOP-SM2-SM3";
    private static final String CERT_DOWNLOAD_API_PARAM_SERIAL_NO = "serialNo";
    private static final String CERT_DOWNLOAD_API_PARAM_CERT_TYPE = "certType";
    private static final LoadingCache<String, List<X509Certificate>> PLATFORM_CERT_CACHE = YopCertificateCache.initCache(24L, TimeUnit.HOURS);
    private static final Map<String, X509Certificate> CFCA_ROOT_CERT_MAP = Maps.newConcurrentMap();
    private static final Map<String, X509Certificate> YOP_INTER_CERT_MAP = Maps.newConcurrentMap();
    private static final Map<String, X509Certificate> YOP_PLATFORM_RSA_CERT_MAP = Maps.newConcurrentMap();
    private static final Map<String, PublicKey> YOP_PLATFORM_RSA_KEY_MAP = Maps.newConcurrentMap();

    public static X509Certificate getCfcaRootCertFromLocal() {
        return YopCertificateCache.getCfcaRootCertFromLocal("", "", "default");
    }

    public static X509Certificate getCfcaRootCertFromLocal(String provider, String env, String appKey) {
        return CFCA_ROOT_CERT_MAP.computeIfAbsent(YopCertificateCache.localKeyId(provider, env, appKey, ""), p -> YopCertificateCache.loadRootCertFromLocal(provider, env, appKey));
    }

    private static X509Certificate loadRootCertFromLocal(String provider, String env, String appKey) {
        try {
            X509Certificate cfcaRootCert = YopCertificateCache.loadPlatformCertFromLocal(provider, env, appKey, "cfca_root.pem", CertTypeEnum.SM2);
            X509CertUtils.verifyCertificate(provider, env, CertTypeEnum.SM2, null, cfcaRootCert);
            return cfcaRootCert;
        }
        catch (YopClientException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 root cert, ex:", (Throwable)e);
            throw new YopClientException("Config Error, platform sm2 root cert not found, provider:" + provider + ", env:" + env + ", appKey:" + appKey);
        }
    }

    private static String localKeyId(String provider, String env, String appKey, String serialNo) {
        return StringUtils.defaultString((String)provider, (String)"") + "," + StringUtils.defaultString((String)env, (String)"") + "," + appKey + "," + serialNo;
    }

    public static X509Certificate getYopInterCertFromLocal() {
        return YopCertificateCache.getYopInterCertFromLocal("", "", "default");
    }

    public static X509Certificate getYopInterCertFromLocal(String provider, String env, String appKey) {
        return YOP_INTER_CERT_MAP.computeIfAbsent(YopCertificateCache.localKeyId(provider, env, appKey, ""), p -> YopCertificateCache.loadInterCertFromLocal(provider, env, appKey));
    }

    private static X509Certificate loadInterCertFromLocal(String provider, String env, String appKey) {
        try {
            X509Certificate yopInterCert = YopCertificateCache.loadPlatformCertFromLocal(provider, env, appKey, "yop_inter.pem", CertTypeEnum.SM2);
            X509CertUtils.verifyCertificate(provider, env, CertTypeEnum.SM2, YopCertificateCache.getCfcaRootCertFromLocal(provider, env, appKey).getPublicKey(), yopInterCert);
            return yopInterCert;
        }
        catch (YopClientException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 inter certs, ex:", (Throwable)e);
            throw new YopClientException("Config Error, platform sm2 inter cert not found, provider:" + provider + ", env:" + env + ", appKey:" + appKey);
        }
    }

    private static X509Certificate loadPlatformCertFromLocal(String provider, String env, String appKey, String certFile, CertTypeEnum certType) {
        Set<String> certDirsOrdered = X509CertUtils.getLocalCertDirs("config/certs", provider, env, appKey);
        for (String certDir : certDirsOrdered) {
            X509Certificate cert = YopCertificateCache.doLoadPlatformCertFromLocal(certDir + "/" + certFile, certType);
            if (null == cert) continue;
            return cert;
        }
        throw new YopClientException("Config Error, platform cert not found, provider:" + provider + ", env:" + env + ", appKey:" + appKey + ", certType:" + certType + ", certFile:" + certFile);
    }

    public static X509Certificate getYopPlatformRsaCertFromLocal() {
        return YopCertificateCache.getYopPlatformRsaCertFromLocal("", "", "default", "rsa");
    }

    public static X509Certificate getYopPlatformRsaCertFromLocal(String provider, String env, String appKey, String serialNo) {
        return YOP_PLATFORM_RSA_CERT_MAP.computeIfAbsent(YopCertificateCache.localKeyId(provider, env, appKey, serialNo), p -> YopCertificateCache.loadPlatformCertFromLocal(provider, env, appKey, "yop_platform_rsa_cert_" + serialNo + ".cer", CertTypeEnum.RSA2048));
    }

    public static PublicKey getYopPlatformRsaKeyFromLocal(String provider, String env, String appKey, String serialNo) {
        return YOP_PLATFORM_RSA_KEY_MAP.computeIfAbsent(YopCertificateCache.localKeyId(provider, env, appKey, serialNo), p -> YopCertificateCache.loadPlatformRsaKeyFromLocal(provider, env, appKey, serialNo));
    }

    private static X509Certificate doLoadPlatformCertFromLocal(String certPath, CertTypeEnum certType) {
        try {
            return YopCertificateCache.getX509Cert(certPath, certType);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("local platform cert not found, certType:{}, certPath:{}, msg:{}", new Object[]{certType, certPath, ExceptionUtils.getMessage((Throwable)e)});
            }
            return null;
        }
    }

    private static PublicKey loadPlatformRsaKeyFromLocal(String provider, String env, String appKey, String serialNo) {
        try {
            YopSdkConfig sdkConfig;
            YopCertConfig[] yopPublicKey;
            PublicKey publicKeyFound;
            if (EnvUtils.isOldSetting(provider, env, appKey)) {
                provider = "yeepay";
                env = "qa";
            }
            if (null != (publicKeyFound = YopCertificateCache.choosePlatformRsaKeyFromLocal(yopPublicKey = (sdkConfig = ClientUtils.getCurrentSdkConfigProvider().getConfig(provider, env)).getYopPublicKey()))) {
                return publicKeyFound;
            }
            return YopCertificateCache.loadPlatformCertFromLocal(provider, env, appKey, "yop_platform_rsa_cert_" + serialNo + ".cer", CertTypeEnum.RSA2048).getPublicKey();
        }
        catch (YopClientException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("error when load yop rsa certs, ex:", (Throwable)e);
            throw new YopClientException("Config Error, platform rsa certs not found, provider:" + provider + ", env:" + env + ", appKey:" + appKey + ", serialNo:" + serialNo);
        }
    }

    private static PublicKey choosePlatformRsaKeyFromLocal(YopCertConfig[] yopPublicKey) {
        if (null != yopPublicKey && yopPublicKey.length > 0) {
            for (int i = 0; i < yopPublicKey.length; ++i) {
                YopCertConfig certConfig = yopPublicKey[i];
                try {
                    if (CertTypeEnum.RSA2048.equals((Object)certConfig.getCertType())) {
                        return ((YopPublicKey)YopCertParserFactory.getCertParser(YopCertCategory.PUBLIC, CertTypeEnum.RSA2048).parse(certConfig)).getPublicKey();
                    }
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("Config Error, yopPublicKey:{}", (Object)certConfig);
                }
            }
        }
        return null;
    }

    public static List<X509Certificate> loadPlatformSm2Certs(String appKey, String serialNo) {
        return YopCertificateCache.loadPlatformSm2Certs(appKey, serialNo, null);
    }

    public static List<X509Certificate> loadPlatformSm2Certs(String appKey, String serialNo, String serverRoot) {
        return YopCertificateCache.loadPlatformSm2Certs("", "", appKey, serialNo, serverRoot);
    }

    public static List<X509Certificate> loadPlatformSm2Certs(String provider, String env, String appKey, String serialNo, String serverRoot) {
        String cacheKey = YopCertificateCache.getCacheKey(provider, env, appKey, serialNo, serverRoot);
        return YopCertificateCache.loadPlatformSm2Certs(cacheKey);
    }

    private static List<X509Certificate> loadPlatformSm2Certs(String cacheKey) {
        try {
            List cachedCerts = (List)PLATFORM_CERT_CACHE.get((Object)cacheKey);
            if (CollectionUtils.isNotEmpty((Collection)cachedCerts)) {
                return cachedCerts;
            }
            PLATFORM_CERT_CACHE.invalidate((Object)cacheKey);
        }
        catch (Exception e) {
            LOGGER.warn("UnexpectedException occurred when load platformCert for cacheKey:" + cacheKey, (Throwable)e);
        }
        return null;
    }

    public static List<X509Certificate> refreshPlatformSm2Certs(String appKey, String serialNo) {
        return YopCertificateCache.refreshPlatformSm2Certs(appKey, serialNo, null);
    }

    public static List<X509Certificate> refreshPlatformSm2Certs(String appKey, String serialNo, String serverRoot) {
        return YopCertificateCache.refreshPlatformSm2Certs("", "", appKey, serialNo, serverRoot);
    }

    public static List<X509Certificate> refreshPlatformSm2Certs(String provider, String env, String appKey, String serialNo, String serverRoot) {
        String cacheKey = YopCertificateCache.getCacheKey(provider, env, appKey, serialNo, serverRoot);
        try {
            PLATFORM_CERT_CACHE.refresh((Object)cacheKey);
        }
        catch (Exception e) {
            LOGGER.warn("UnexpectedException occurred when refresh platformCert for cacheKey:" + cacheKey, (Throwable)e);
        }
        return YopCertificateCache.loadPlatformSm2Certs(cacheKey);
    }

    public static List<X509Certificate> reloadPlatformSm2Certs(String appKey, String serialNo) {
        return YopCertificateCache.reloadPlatformSm2Certs(appKey, serialNo, null);
    }

    public static List<X509Certificate> reloadPlatformSm2Certs(String appKey, String serialNo, String serverRoot) {
        return YopCertificateCache.reloadPlatformSm2Certs("", "", appKey, serialNo, serverRoot);
    }

    public static List<X509Certificate> reloadPlatformSm2Certs(String provider, String env, String appKey, String serialNo, String serverRoot) {
        String cacheKey = YopCertificateCache.getCacheKey(provider, env, appKey, serialNo, serverRoot);
        try {
            PLATFORM_CERT_CACHE.invalidate((Object)cacheKey);
        }
        catch (Exception e) {
            LOGGER.warn("UnexpectedException occurred when invalidate platformCert for cacheKey:" + cacheKey, (Throwable)e);
        }
        return YopCertificateCache.loadPlatformSm2Certs(cacheKey);
    }

    private static String getCacheKey(String provider, String env, String appKey, String serialNo, String serverRoot) {
        return StringUtils.joinWith((String)",", (Object[])new Object[]{StringUtils.defaultIfBlank((CharSequence)provider, (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)env, (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)appKey, (CharSequence)"default"), StringUtils.defaultIfBlank((CharSequence)serialNo, (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)serverRoot, (CharSequence)"")});
    }

    private static synchronized List<X509Certificate> doLoad(String provider, String env, String appKey, String serialNo, String serverRoot) {
        List<X509Certificate> result = Collections.emptyList();
        try {
            YopCredentials<?> yopCredentials = YopCredentialsCache.get(provider, env, appKey);
            YopRequest request = new YopRequest(CERT_DOWNLOAD_API_URI, CERT_DOWNLOAD_API_METHOD);
            request.getRequestConfig().setSkipVerifySign(true).setNeedEncrypt(false).setSecurityReq(CERT_DOWNLOAD_API_SECURITY).setCredentials(yopCredentials);
            if (StringUtils.isNotBlank((CharSequence)serialNo)) {
                request.addParameter(CERT_DOWNLOAD_API_PARAM_SERIAL_NO, serialNo);
            }
            if (StringUtils.isNotBlank((CharSequence)serverRoot)) {
                request.getRequestConfig().setServerRoot(serverRoot);
            }
            request.addParameter(CERT_DOWNLOAD_API_PARAM_CERT_TYPE, CertTypeEnum.SM2.getValue());
            YopResponse response = ClientUtils.getAvailableYopClient(provider, env).request(request);
            List<YopPlatformPlainCert> platformCerts = YopCertificateCache.parseYopResponse(response);
            List<X509Certificate> legalPlatformCerts = YopCertificateCache.checkCerts(provider, env, appKey, platformCerts);
            if (CollectionUtils.isNotEmpty(legalPlatformCerts)) {
                result = legalPlatformCerts;
            }
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 cert from remote, ex:", (Throwable)e);
        }
        return result;
    }

    private static List<YopPlatformPlainCert> parseYopResponse(YopResponse response) {
        try {
            YopPlatformCertQueryResult bizResponse = new YopPlatformCertQueryResult();
            JsonUtils.load(response.getStringResult(), (Object)bizResponse);
            return bizResponse.getData();
        }
        catch (Exception e) {
            LOGGER.error("error when load sm2 cert, ex:", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<X509Certificate> checkCerts(String provider, String env, String appKey, List<YopPlatformPlainCert> platformCerts) {
        if (CollectionUtils.isNotEmpty(platformCerts)) {
            ArrayList result = Lists.newArrayList();
            for (YopPlatformPlainCert platformCert : platformCerts) {
                X509Certificate tmp = YopCertificateCache.decodeCert(platformCert);
                if (null != tmp) {
                    tmp = YopCertificateCache.verifyCert(provider, env, appKey, tmp);
                }
                if (null == tmp) continue;
                result.add(tmp);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static X509Certificate decodeCert(YopPlatformPlainCert platformCert) {
        try {
            byte[] certBytes = platformCert.getCert().getBytes("UTF-8");
            return X509CertUtils.getX509Certificate(CertTypeEnum.SM2, certBytes);
        }
        catch (Exception e) {
            LOGGER.warn("fail to decode platform cert:" + platformCert + ", ex:", (Throwable)e);
            return null;
        }
    }

    private static X509Certificate verifyCert(String provider, String env, String appKey, X509Certificate platformCert) {
        try {
            X509CertUtils.verifyCertificate(provider, env, CertTypeEnum.SM2, YopCertificateCache.getYopInterCertFromLocal(provider, env, appKey).getPublicKey(), platformCert);
            return platformCert;
        }
        catch (Exception e) {
            LOGGER.error("error to verify platform cert:" + platformCert + ", ex:", (Throwable)e);
            return null;
        }
    }

    private static X509Certificate getX509Cert(String certPath, CertTypeEnum certType) {
        YopCertConfig yopCertConfig = new YopCertConfig();
        yopCertConfig.setCertType(certType);
        yopCertConfig.setValue(certPath);
        yopCertConfig.setStoreType(CertStoreType.FILE_CER);
        return ((YopPublicKey)YopCertParserFactory.getCertParser(YopCertCategory.PUBLIC, certType).parse(yopCertConfig)).getCert();
    }

    private static LoadingCache<String, List<X509Certificate>> initCache(Long expire, TimeUnit timeUnit) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expire > 0L) {
            cacheBuilder.expireAfterWrite(expire.longValue(), timeUnit);
        }
        return cacheBuilder.build((CacheLoader)new CacheLoader<String, List<X509Certificate>>(){

            public List<X509Certificate> load(String cacheKey) throws Exception {
                LOGGER.debug("try to init platform cert for cacheKey:" + cacheKey);
                List platformCert = Collections.emptyList();
                try {
                    String[] split = StringUtils.splitPreserveAllTokens((String)cacheKey, (String)",");
                    String provider = split[0];
                    String env = split[1];
                    String appKey = split[2];
                    String serialNo = split.length > 3 ? split[3] : null;
                    String serverRoot = split.length > 4 ? split[4] : null;
                    platformCert = YopCertificateCache.doLoad(provider, env, appKey, serialNo, serverRoot);
                }
                catch (Exception ex) {
                    LOGGER.warn("UnexpectedException occurred when init platformCert for cacheKey:" + cacheKey, (Throwable)ex);
                }
                return platformCert;
            }
        });
    }
}

