/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.config.provider;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.config.YopSdkConfig;
import com.yeepay.yop.sdk.config.provider.YopSdkConfigProvider;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopFixedSdkConfigProvider
implements YopSdkConfigProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, YopSdkConfig> sdkConfigMap = Maps.newConcurrentMap();

    public final YopSdkConfig getConfig() {
        return this.getConfig("", "");
    }

    public YopSdkConfig getConfig(String provider, String env) {
        String theProvider = StringUtils.defaultString((String)provider, (String)"");
        String theEnv = StringUtils.defaultString((String)env, (String)"");
        return this.sdkConfigMap.computeIfAbsent(theProvider + "#" + theEnv, p -> this.loadSdkConfig(theProvider, theEnv));
    }

    protected abstract YopSdkConfig loadSdkConfig();

    protected YopSdkConfig loadSdkConfig(String provider, String env) {
        return this.loadSdkConfig();
    }
}

