/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.cert.parser;

import com.yeepay.yop.sdk.utils.FileUtils;
import com.yeepay.yop.sdk.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractYopPrivateKeyParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrivateKey parsePrivateKey(String keyStorePwd, String keyStorePath) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException {
        String pwd = (String)StringUtils.defaultIfEmpty((CharSequence)keyStorePwd, (CharSequence)"");
        char[] password = pwd.toCharArray();
        KeyStore keystore = this.getKeyStore();
        InputStream keyStream = null;
        try {
            keyStream = FileUtils.getResourceAsStream(keyStorePath);
            keystore.load(keyStream, password);
        }
        finally {
            StreamUtils.closeQuietly(keyStream);
        }
        Enumeration<String> aliases = keystore.aliases();
        Key key = null;
        while (aliases.hasMoreElements() && !(key instanceof PrivateKey)) {
            String keyAlias = aliases.nextElement();
            key = keystore.getKey(keyAlias, password);
        }
        return (PrivateKey)key;
    }

    protected abstract KeyStore getKeyStore() throws KeyStoreException, NoSuchProviderException;
}

