/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.base.security.encrypt;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptionsEnhancer;
import com.yeepay.yop.sdk.security.encrypt.YopEncryptor;
import com.yeepay.yop.sdk.utils.ClientUtils;
import com.yeepay.yop.sdk.utils.Encodes;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YopEncryptorAdaptor
implements YopEncryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopEncryptorAdaptor.class);
    private static final String ENCRYPT_OPTIONS_INIT_THREAD_NAME_PREFIX = "yop-encrypt-options-init-task-";
    protected static final ThreadPoolExecutor THREAD_POOL = new ThreadPoolExecutor(2, 20, 3L, TimeUnit.MINUTES, Queues.newLinkedBlockingQueue((int)200), new ThreadFactoryBuilder().setNameFormat("yop-encrypt-options-init-task-%d").setDaemon(true).build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public Future<EncryptOptions> initOptions(String encryptAlg, List<EncryptOptionsEnhancer> enhancers) {
        return THREAD_POOL.submit(new InitOptionsTask(encryptAlg, enhancers));
    }

    public String encryptToBase64(String plain, EncryptOptions options) {
        try {
            return Encodes.encodeUrlSafeBase64(this.encrypt(plain.getBytes("UTF-8"), options));
        }
        catch (UnsupportedEncodingException e) {
            throw new YopClientException("UnexpectedError, EncryptFail, value:" + plain + ",options:" + options + ",ex:", (Throwable)e);
        }
    }

    public String encryptToBase64(byte[] plain, EncryptOptions options) {
        return Encodes.encodeUrlSafeBase64(this.encrypt(plain, options));
    }

    public String decryptFromBase64(String cipher, EncryptOptions options) {
        return this.decryptToPlain(Encodes.decodeBase64(cipher), options);
    }

    public String decryptToPlain(byte[] cipher, EncryptOptions options) {
        try {
            return new String(this.decrypt(cipher, options), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new YopClientException("UnexpectedError, DecryptFail, options:" + options + ",ex:", (Throwable)e);
        }
    }

    public abstract EncryptOptions doInitEncryptOptions(String var1) throws Exception;

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                boolean finished = false;
                try {
                    THREAD_POOL.shutdown();
                    finished = THREAD_POOL.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOGGER.error("error when shutdown threadpool, finished:{}, ex:", (Object)finished, (Object)e);
                }
            }
        });
    }

    private class InitOptionsTask
    implements Callable<EncryptOptions> {
        private final String encryptAlg;
        private final List<EncryptOptionsEnhancer> enhancers;

        public InitOptionsTask(String encryptAlg, List<EncryptOptionsEnhancer> enhancers) {
            this.encryptAlg = encryptAlg;
            this.enhancers = enhancers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EncryptOptions call() throws Exception {
            try {
                EncryptOptions inited = YopEncryptorAdaptor.this.doInitEncryptOptions(this.encryptAlg);
                if (CollectionUtils.isNotEmpty(this.enhancers)) {
                    for (EncryptOptionsEnhancer enhancer : this.enhancers) {
                        inited = enhancer.enhance(inited);
                    }
                }
                EncryptOptions encryptOptions = inited;
                return encryptOptions;
            }
            finally {
                if (StringUtils.startsWith((CharSequence)Thread.currentThread().getName(), (CharSequence)YopEncryptorAdaptor.ENCRYPT_OPTIONS_INIT_THREAD_NAME_PREFIX) && StringUtils.isNotBlank((CharSequence)ClientUtils.getCurrentClientId())) {
                    ClientUtils.removeCurrentClientId();
                }
            }
        }
    }
}

