/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.metric;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class YopFailureItem
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String exType;
    private String exMsg;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS", timezone="GMT+8")
    private Date occurDate;

    public YopFailureItem(String exType, String exMsg) {
        this.exType = exType;
        this.exMsg = exMsg;
        this.occurDate = new Date();
    }

    public YopFailureItem(Throwable ex) {
        Throwable exCause = ExceptionUtils.getRootCause((Throwable)ex);
        if (null == exCause) {
            exCause = ex;
        }
        this.exType = exCause.getClass().getCanonicalName();
        this.exMsg = StringUtils.abbreviate((String)StringUtils.defaultString((String)exCause.getMessage(), (String)""), (int)300);
        this.occurDate = new Date();
    }

    public String getExType() {
        return this.exType;
    }

    public String getExMsg() {
        return this.exMsg;
    }

    public Date getOccurDate() {
        return this.occurDate;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

