/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.client.router;

import com.yeepay.yop.sdk.YopConstants;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class ServerRootSpace
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final String provider;
    private final String env;
    private final URI serverRoot;
    private final URI yosServerRoot;
    private final List<URI> preferredEndPoint;
    private final List<URI> preferredYosEndPoint;
    private final URI sandboxServerRoot;

    public ServerRootSpace(URI serverRoot, URI yosServerRoot, URI sandboxServerRoot) {
        this.provider = "";
        this.env = "";
        this.serverRoot = serverRoot;
        this.yosServerRoot = yosServerRoot;
        this.preferredEndPoint = YopConstants.DEFAULT_PREFERRED_SERVER_ROOT;
        this.preferredYosEndPoint = Collections.emptyList();
        this.sandboxServerRoot = sandboxServerRoot;
    }

    public ServerRootSpace(URI serverRoot, URI yosServerRoot, List<URI> preferredEndPoint, List<URI> preferredYosEndPoint, URI sandboxServerRoot) {
        this.provider = "";
        this.env = "";
        this.serverRoot = serverRoot;
        this.yosServerRoot = yosServerRoot;
        this.preferredEndPoint = CollectionUtils.isEmpty(preferredEndPoint) ? YopConstants.DEFAULT_PREFERRED_SERVER_ROOT : preferredEndPoint;
        this.preferredYosEndPoint = preferredYosEndPoint;
        this.sandboxServerRoot = sandboxServerRoot;
    }

    public ServerRootSpace(String provider, String env, URI serverRoot, URI yosServerRoot, List<URI> preferredEndPoint, List<URI> preferredYosEndPoint, URI sandboxServerRoot) {
        this.provider = provider;
        this.env = env;
        this.serverRoot = serverRoot;
        this.yosServerRoot = yosServerRoot;
        this.preferredEndPoint = CollectionUtils.isEmpty(preferredEndPoint) ? YopConstants.DEFAULT_PREFERRED_SERVER_ROOT : preferredEndPoint;
        this.preferredYosEndPoint = preferredYosEndPoint;
        this.sandboxServerRoot = sandboxServerRoot;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getEnv() {
        return this.env;
    }

    public URI getServerRoot() {
        return this.serverRoot;
    }

    public URI getYosServerRoot() {
        return this.yosServerRoot;
    }

    public List<URI> getPreferredEndPoint() {
        return this.preferredEndPoint;
    }

    public List<URI> getPreferredYosEndPoint() {
        return this.preferredYosEndPoint;
    }

    public URI getSandboxServerRoot() {
        return this.sandboxServerRoot;
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.env, this.serverRoot, this.yosServerRoot, this.sandboxServerRoot, this.preferredEndPoint, this.preferredYosEndPoint);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerRootSpace) {
            ServerRootSpace that = (ServerRootSpace)obj;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.env, that.env) && Objects.equals(this.serverRoot, that.serverRoot) && Objects.equals(this.yosServerRoot, that.yosServerRoot) && Objects.equals(this.sandboxServerRoot, that.sandboxServerRoot) && Objects.equals(this.preferredEndPoint, that.preferredEndPoint) && Objects.equals(this.preferredYosEndPoint, that.preferredYosEndPoint);
        }
        return false;
    }
}

