/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.http.handler;

import com.yeepay.yop.sdk.http.HttpResponseAnalyzer;
import com.yeepay.yop.sdk.http.HttpResponseHandleContext;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseResponse;

public class DefaultHttpResponseHandler<T extends BaseResponse>
implements HttpResponseHandler<T> {
    private final Class<T> responseClass;
    private final HttpResponseAnalyzer[] analyzers;

    public DefaultHttpResponseHandler(Class<T> responseClass, HttpResponseAnalyzer[] analyzers) {
        this.responseClass = responseClass;
        this.analyzers = analyzers;
    }

    @Override
    public T handle(HttpResponseHandleContext context) throws Exception {
        BaseResponse response = (BaseResponse)this.responseClass.newInstance();
        for (HttpResponseAnalyzer analyzer : this.analyzers) {
            if (analyzer.analysis(context, response)) break;
        }
        return (T)response;
    }
}

