/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.internal;

import com.yeepay.yop.sdk.internal.MarkableFileInputStream;
import com.yeepay.yop.sdk.utils.FileUtils;
import com.yeepay.yop.sdk.utils.checksum.CRC64;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.zip.CheckedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartFile
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPartFile.class);
    private static final long serialVersionUID = -1L;
    private static final int EXT_READ_BUFFER_SIZE = 65536;
    private static final Pattern FILE_EXT_NAME_PATTERN = Pattern.compile("^\\.[^.\\s]+");
    private final CheckedInputStream inputStream;
    private final String fileName;

    public MultiPartFile(File file) throws IOException {
        this(new FileInputStream(file), file.getName(), true);
    }

    public MultiPartFile(InputStream in) throws IOException {
        Pair<String, CheckedInputStream> inputStreamPair = MultiPartFile.getCheckedInputStreamPair(in);
        this.fileName = FileUtils.randomFileName(8, (String)inputStreamPair.getLeft());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("file autoDetect, auto:{}", (Object)this.fileName);
        }
        this.inputStream = (CheckedInputStream)inputStreamPair.getRight();
    }

    public MultiPartFile(InputStream in, String originFileName) throws IOException {
        this(in, originFileName, false);
    }

    public MultiPartFile(InputStream in, String originFileName, boolean autoDetect) throws IOException {
        if (autoDetect) {
            Pair<String, CheckedInputStream> checkedInputStreamPair = MultiPartFile.getCheckedInputStreamPair(in);
            String autoFileExtName = (String)checkedInputStreamPair.getLeft();
            if (null != autoFileExtName && FILE_EXT_NAME_PATTERN.matcher(autoFileExtName).matches()) {
                this.fileName = StringUtils.substringBeforeLast((String)originFileName, (String)".") + autoFileExtName;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.info("file autoDetect, origin:{}, auto:{}", (Object)originFileName, (Object)this.fileName);
                }
            } else {
                this.fileName = originFileName;
            }
            this.inputStream = (CheckedInputStream)checkedInputStreamPair.getRight();
        } else {
            this.fileName = originFileName;
            this.inputStream = MultiPartFile.getCheckedInputStream(in);
        }
    }

    public MultiPartFile(String fileExtName, InputStream in) throws IOException {
        this.fileName = FileUtils.randomFileName(8, fileExtName);
        this.inputStream = MultiPartFile.getCheckedInputStream(in);
    }

    public CheckedInputStream getInputStream() {
        return this.inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    private static Pair<String, CheckedInputStream> getCheckedInputStreamPair(InputStream inputStream) throws IOException {
        if (inputStream instanceof FileInputStream) {
            MarkableFileInputStream in = new MarkableFileInputStream((FileInputStream)inputStream);
            in.mark(0);
            String fileExtName = FileUtils.getFileExt(in);
            in.reset();
            return new ImmutablePair((Object)fileExtName, (Object)MultiPartFile.getCheckedInputStream(in));
        }
        byte[] extReadBuffer = new byte[65536];
        int totalRead = 0;
        int lastRead = inputStream.read(extReadBuffer);
        while (lastRead != -1 && (totalRead += lastRead) != 65536) {
            lastRead = inputStream.read(extReadBuffer, totalRead, 65536 - totalRead);
        }
        ByteArrayInputStream extReadIn = new ByteArrayInputStream(extReadBuffer, 0, totalRead);
        String fileExtName = FileUtils.getFileExt(extReadIn);
        extReadIn.reset();
        SequenceInputStream sequenceInputStream = new SequenceInputStream(extReadIn, inputStream);
        return new ImmutablePair((Object)fileExtName, (Object)MultiPartFile.getCheckedInputStream(sequenceInputStream));
    }

    private static CheckedInputStream getCheckedInputStream(InputStream inputStream) throws IOException {
        return new CheckedInputStream(inputStream, new CRC64());
    }
}

