/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.protocol;

import com.google.common.collect.Maps;
import java.util.Map;

public enum AuthenticateProtocolVersion {
    YOP_V2("yop-auth-v2", 2),
    YOP_V3("yop-auth-v3", 3);

    private String versionInStringFormat;
    private int versionInNumberFormat;
    private static final Map<String, AuthenticateProtocolVersion> VALUE_MAP;

    private AuthenticateProtocolVersion(String versionInStringFormat, int versionInNumberFormat) {
        this.versionInStringFormat = versionInStringFormat;
        this.versionInNumberFormat = versionInNumberFormat;
    }

    public static AuthenticateProtocolVersion parse(String versionInStringFormat) {
        return VALUE_MAP.get(versionInStringFormat);
    }

    public String stringFormat() {
        return this.versionInStringFormat;
    }

    public Integer numberFormat() {
        return this.versionInNumberFormat;
    }

    static {
        VALUE_MAP = Maps.newHashMap();
        for (AuthenticateProtocolVersion item : AuthenticateProtocolVersion.values()) {
            VALUE_MAP.put(item.versionInStringFormat, item);
        }
    }
}

