/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.sentinel;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.ErrorEntryFreeException;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.context.NullContext;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.util.function.BiConsumer;
import java.util.LinkedList;

public class YopEntry
extends Entry {
    protected Entry parent = null;
    protected Entry child = null;
    protected ProcessorSlot<Object> chain;
    protected Context context;
    protected LinkedList<BiConsumer<Context, Entry>> exitHandlers;

    YopEntry(ResourceWrapper resourceWrapper, ProcessorSlot<Object> chain, Context context) {
        super(resourceWrapper);
        this.chain = chain;
        this.context = context;
        this.setUpEntryFor(context);
    }

    private void setUpEntryFor(Context context) {
        if (context instanceof NullContext) {
            return;
        }
        this.parent = context.getCurEntry();
        if (this.parent != null) {
            ((YopEntry)this.parent).child = this;
        }
        context.setCurEntry((Entry)this);
    }

    public void exit(int count, Object ... args) throws ErrorEntryFreeException {
        this.trueExit(count, args);
    }

    private void callExitHandlersAndCleanUp(Context ctx) {
        if (this.exitHandlers != null && !this.exitHandlers.isEmpty()) {
            for (BiConsumer biConsumer : this.exitHandlers) {
                if (null == biConsumer) continue;
                try {
                    biConsumer.accept((Object)ctx, (Object)this);
                }
                catch (Exception e) {
                    RecordLog.warn((String)("Error occurred when invoking entry exit handler, current entry: " + this.resourceWrapper.getName()), (Throwable)e);
                }
            }
            this.exitHandlers = null;
        }
    }

    protected void exitForContext(Context context, int count, Object ... args) throws ErrorEntryFreeException {
        if (context != null) {
            if (context instanceof NullContext) {
                return;
            }
            if (context.getCurEntry() != this) {
                String curEntryNameInContext = context.getCurEntry() == null ? null : context.getCurEntry().getResourceWrapper().getName();
                YopEntry e = (YopEntry)context.getCurEntry();
                while (e != null) {
                    e.exit(count, args);
                    e = (YopEntry)e.parent;
                }
                String errorMessage = String.format("The order of entry exit can't be paired with the order of entry, current entry in context: <%s>, but expected: <%s>", curEntryNameInContext, this.resourceWrapper.getName());
                throw new ErrorEntryFreeException(errorMessage);
            }
            if (this.chain != null) {
                this.chain.exit(context, this.resourceWrapper, count, args);
            }
            this.callExitHandlersAndCleanUp(context);
            context.setCurEntry(this.parent);
            if (this.parent != null) {
                ((YopEntry)this.parent).child = null;
            }
            if (this.parent == null && ContextUtil.isDefaultContext((Context)context)) {
                ContextUtil.exit();
            }
            this.clearEntryContext();
        }
    }

    protected void clearEntryContext() {
        this.context = null;
    }

    public void whenTerminate(BiConsumer<Context, Entry> handler) {
        if (this.exitHandlers == null) {
            this.exitHandlers = new LinkedList();
        }
        this.exitHandlers.add(handler);
    }

    protected Entry trueExit(int count, Object ... args) throws ErrorEntryFreeException {
        this.exitForContext(this.context, count, args);
        return this.parent;
    }

    public Node getLastNode() {
        return this.parent == null ? null : this.parent.getCurNode();
    }
}

