/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.common.callback.protocol;

import com.yeepay.yop.sdk.auth.credentials.YopSymmetricCredentials;
import com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.encrypt.BigParamEncryptMode;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import com.yeepay.yop.sdk.service.common.callback.YopCallback;
import com.yeepay.yop.sdk.service.common.callback.protocol.AbstractYopCallbackProtocol;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSm4CallbackProtocol
extends AbstractYopCallbackProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSm4CallbackProtocol.class);
    private String algorithm = "AEAD_SM4_GCM";
    private CertTypeEnum certType = CertTypeEnum.SM4;
    private String customerIdentification;
    private String cipherText;
    private String nonce;
    private String associatedData;

    @Override
    public YopCallback parse() {
        String encryptAlg = "SM4/GCM/NoPadding";
        List isvEncryptKeys = YopCredentialsProviderRegistry.getProvider().getIsvEncryptKey(this.originRequest.getProvider(), this.originRequest.getEnv(), this.customerIdentification);
        if (CollectionUtils.isEmpty((Collection)isvEncryptKeys)) {
            throw new YopClientException("no isvEncryptKeys found for appKey:" + this.customerIdentification);
        }
        for (YopCertConfig isvEncryptKey : isvEncryptKeys) {
            try {
                String plainText = YopEncryptorFactory.getEncryptor("SM4/GCM/NoPadding").decryptFromBase64(this.cipherText, new EncryptOptions((Object)new YopSymmetricCredentials(isvEncryptKey.getValue()), "", "SM4/GCM/NoPadding", this.nonce, this.associatedData, BigParamEncryptMode.stream));
                if (null == plainText) continue;
                return YopCallback.builder().withId(UUID.randomUUID().toString()).withAppKey(this.customerIdentification).withType(this.originRequest.getHttpPath()).withCreateTime(new Date()).withBizData(plainText).withMetaInfo("headers", this.originRequest.getHeaders()).build();
            }
            catch (Exception e) {
                LOGGER.warn("fail to parse YopSm4CallbackProtocol with key:" + isvEncryptKey.getValue() + ", ex:", (Throwable)e);
            }
        }
        throw new YopClientException("fail to parse YopSm4CallbackProtocol, appKey:" + this.customerIdentification);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCustomerIdentification() {
        return this.customerIdentification;
    }

    public String getCipherText() {
        return this.cipherText;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAssociatedData() {
        return this.associatedData;
    }

    public YopSm4CallbackProtocol setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public YopSm4CallbackProtocol setCertType(CertTypeEnum certType) {
        this.certType = certType;
        return this;
    }

    public YopSm4CallbackProtocol setCustomerIdentification(String customerIdentification) {
        this.customerIdentification = customerIdentification;
        return this;
    }

    public YopSm4CallbackProtocol setCipherText(String cipherText) {
        this.cipherText = cipherText;
        return this;
    }

    public YopSm4CallbackProtocol setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public YopSm4CallbackProtocol setAssociatedData(String associatedData) {
        this.associatedData = associatedData;
        return this;
    }
}

