/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import org.apache.commons.lang3.StringUtils;

public final class EnvUtils {
    private static final String ENV_SANDBOX_APP_PREFIX = "sandbox_";
    private static final String ENV_PROP = "yop.sdk.config.env";
    private static final String MODE_PROP = "yop.sdk.mode";
    private static final String MODE_SANDBOX = "sandbox";

    public static boolean isProd() {
        return "prod".equals(EnvUtils.currentEnv());
    }

    public static boolean isSandBoxEnv(String env) {
        return MODE_SANDBOX.equals(env);
    }

    @Deprecated
    public static boolean isSandBoxMode() {
        return MODE_SANDBOX.equals(System.getProperty(MODE_PROP));
    }

    @Deprecated
    public static boolean isSandboxApp(String appKey) {
        return StringUtils.startsWith((CharSequence)appKey, (CharSequence)ENV_SANDBOX_APP_PREFIX);
    }

    @Deprecated
    public static boolean isOldSetting(String provider, String env, String appKey) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{provider, env})) {
            String customEnvProperty = EnvUtils.getCustomEnvProperty();
            if (EnvUtils.isSandboxApp(appKey) || EnvUtils.isSandBoxMode() || null != customEnvProperty && !EnvUtils.isProd()) {
                return true;
            }
        }
        return false;
    }

    public static String currentEnv() {
        return System.getProperty(ENV_PROP, "prod");
    }

    public static String getCustomEnvProperty() {
        return System.getProperty(ENV_PROP);
    }
}

