/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSdkInitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSdkInitUtils.class);
    private static final String[] SPI_CLASSES = new String[]{"com.yeepay.yop.sdk.base.security.cert.X509CertSupportFactory", "com.yeepay.yop.sdk.base.auth.signer.YopSignerFactory", "com.yeepay.yop.sdk.base.auth.signer.process.YopSignProcessorFactory", "com.yeepay.yop.sdk.base.security.cert.parser.YopCertParserFactory", "com.yeepay.yop.sdk.base.security.digest.YopDigesterFactory", "com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorFactory", "com.yeepay.yop.sdk.auth.credentials.provider.YopCredentialsProviderRegistry", "com.yeepay.yop.sdk.auth.credentials.provider.YopPlatformCredentialsProviderRegistry", "com.yeepay.yop.sdk.client.cmd.YopCmdExecutorRegistry", "com.yeepay.yop.sdk.http.YopHttpClientFactory"};

    public static void loadSpiClasses(String ... args) {
        for (String spiClass : SPI_CLASSES) {
            YopSdkInitUtils.doLoadSpiClass(spiClass);
        }
        if (null != args) {
            for (String arg : args) {
                YopSdkInitUtils.doLoadSpiClass(arg);
            }
        }
    }

    private static void doLoadSpiClass(String spiClass) {
        try {
            Class<?> clazz = Class.forName(spiClass);
            LOGGER.info("spi class load success, name:{}, loader:{}", (Object)spiClass, (Object)clazz.getClassLoader());
        }
        catch (Throwable e) {
            LOGGER.error("spi class load fail, name:{}, loader:{}, ex:", new Object[]{spiClass, Thread.currentThread().getContextClassLoader(), e});
        }
    }
}

