/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.security.encrypt;

import com.yeepay.yop.sdk.auth.credentials.PKICredentialsItem;
import com.yeepay.yop.sdk.auth.credentials.YopPKICredentials;
import com.yeepay.yop.sdk.auth.credentials.YopPlatformCredentials;
import com.yeepay.yop.sdk.base.security.encrypt.YopEncryptorAdaptor;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.gm.base.utils.SmUtils;
import com.yeepay.yop.sdk.security.encrypt.EncryptOptions;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class YopSm2Encryptor
extends YopEncryptorAdaptor {
    private static final String ENCRYPT_ALG = "SM2";
    private static final ThreadLocal<SM2Engine> engineThreadLocal;

    public List<String> supportedAlgs() {
        return Collections.singletonList(ENCRYPT_ALG);
    }

    public EncryptOptions doInitEncryptOptions(String encryptAlg) throws Exception {
        return null;
    }

    public byte[] encrypt(byte[] plain, EncryptOptions options) {
        try {
            SM2Engine engine = engineThreadLocal.get();
            ECPublicKeyParameters pubKeyParameters = this.convertPublicKeyToParameters((BCECPublicKey)((PKICredentialsItem)((YopPlatformCredentials)options.getCredentials()).getCredential()).getPublicKey());
            ParametersWithRandom pwr = new ParametersWithRandom((CipherParameters)pubKeyParameters, new SecureRandom());
            engine.init(true, (CipherParameters)pwr);
            return engine.processBlock(plain, 0, plain.length);
        }
        catch (Throwable e) {
            throw new YopClientException("SystemError, Encrypt Fail, options:" + options, e);
        }
    }

    public InputStream encrypt(InputStream plain, EncryptOptions options) {
        return null;
    }

    public byte[] decrypt(byte[] cipher, EncryptOptions options) {
        try {
            SM2Engine engine = engineThreadLocal.get();
            ECPrivateKeyParameters priKeyParameters = this.convertPrivateKeyToParameters((BCECPrivateKey)((YopPKICredentials)options.getCredentials()).getCredential().getPrivateKey());
            engine.init(false, (CipherParameters)priKeyParameters);
            return engine.processBlock(cipher, 0, cipher.length);
        }
        catch (Throwable e) {
            throw new YopClientException("SystemError, Decrypt Fail, options:" + options, e);
        }
    }

    public InputStream decrypt(InputStream cipher, EncryptOptions options) {
        return null;
    }

    private ECPublicKeyParameters convertPublicKeyToParameters(BCECPublicKey ecPubKey) {
        ECParameterSpec parameterSpec = ecPubKey.getParameters();
        ECDomainParameters domainParameters = new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
        return new ECPublicKeyParameters(ecPubKey.getQ(), domainParameters);
    }

    private ECPrivateKeyParameters convertPrivateKeyToParameters(BCECPrivateKey ecPriKey) {
        ECParameterSpec parameterSpec = ecPriKey.getParameters();
        ECDomainParameters domainParameters = new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
        return new ECPrivateKeyParameters(ecPriKey.getD(), domainParameters);
    }

    static {
        SmUtils.init();
        engineThreadLocal = new ThreadLocal<SM2Engine>(){

            @Override
            protected SM2Engine initialValue() {
                return new SM2Engine(SM2Engine.Mode.C1C3C2);
            }
        };
    }
}

