/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.util.Collect;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveDestinationNameResolver {
    private final Logger LOGGER = LoggerFactory.getLogger(ArchiveDestinationNameResolver.class);
    private final List<String> destinationNames;
    private ResolvedDestinationName destinationName;

    public ArchiveDestinationNameResolver(List<String> destinationNames) {
        this.destinationNames = destinationNames;
        this.destinationName = ResolvedDestinationName.unresolved();
    }

    public void validate(OracleConnection connection) {
        if (!this.destinationName.resolved()) {
            this.destinationName = this.resolveDestinationName(connection);
        }
        try {
            if (!Strings.isNullOrEmpty((String)this.destinationName.value())) {
                if (!connection.isArchiveLogDestinationValid(this.destinationName.value())) {
                    this.LOGGER.warn("Archive log destination '{}' may not be valid, please check the database.", (Object)this.destinationName.value());
                }
            } else if (!connection.isOnlyOneArchiveLogDestinationValid()) {
                this.LOGGER.warn("There are multiple valid archive log destinations. Please add '{}' to the connector configuration to avoid log availability problems.", (Object)OracleConnectorConfig.ARCHIVE_DESTINATION_NAME.name());
            }
        }
        catch (SQLException e) {
            throw new DebeziumException("Error while checking validity of archive log configuration", (Throwable)e);
        }
    }

    public String getDestinationName(OracleConnection connection) {
        if (!this.destinationName.resolved()) {
            this.destinationName = this.resolveDestinationName(connection);
        }
        return this.destinationName.value();
    }

    private ResolvedDestinationName resolveDestinationName(OracleConnection connection) {
        try {
            if (!Collect.isNullOrEmpty(this.destinationNames)) {
                for (String destinationName : this.destinationNames) {
                    if (!connection.isArchiveLogDestinationValid(destinationName)) continue;
                    this.LOGGER.info("Using archive destination {}", (Object)destinationName);
                    return ResolvedDestinationName.resolved(destinationName);
                }
                this.LOGGER.warn("No valid archive destination detected in '{}'", this.destinationNames);
                return ResolvedDestinationName.resolved((String)this.destinationNames.stream().findFirst().get());
            }
            return ResolvedDestinationName.resolved(null);
        }
        catch (SQLException e) {
            throw new DebeziumException("Error while checking validity of archive destination configuration", (Throwable)e);
        }
    }

    private record ResolvedDestinationName(boolean resolved, String value) {
        public static ResolvedDestinationName unresolved() {
            return new ResolvedDestinationName(false, null);
        }

        public static ResolvedDestinationName resolved(String value) {
            return new ResolvedDestinationName(true, value);
        }
    }
}

