/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered;

import io.debezium.connector.oracle.logminer.buffered.LogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.Transaction;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractLogMinerTransactionCache<T extends Transaction>
implements LogMinerTransactionCache<T> {
    private final Set<String> abandonedTransactions = new HashSet<String>();

    @Override
    public void abandon(T transaction) {
        this.abandonedTransactions.add(transaction.getTransactionId());
    }

    @Override
    public void removeAbandonedTransaction(String transactionId) {
        this.abandonedTransactions.remove(transactionId);
    }

    @Override
    public boolean isAbandoned(String transactionId) {
        return this.abandonedTransactions.contains(transactionId);
    }

    @Override
    public void resetTransactionToStart(T transaction) {
        transaction.start();
    }

    @Override
    public Optional<LogMinerTransactionCache.ScnDetails> getEldestTransactionScnDetailsInCache() {
        return this.streamTransactionsAndReturn(stream -> stream.min(this::compareTransactionScnDetails).map(transaction -> new LogMinerTransactionCache.ScnDetails(transaction.getStartScn(), transaction.getChangeTime())));
    }

    private int compareTransactionScnDetails(T first, T second) {
        int scnComparison = first.getStartScn().compareTo(second.getStartScn());
        if (scnComparison != 0) {
            return scnComparison;
        }
        return first.getChangeTime().compareTo(second.getChangeTime());
    }
}

