/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.buffered.memory;

import io.debezium.connector.oracle.logminer.buffered.AbstractLogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.LogMinerTransactionCache;
import io.debezium.connector.oracle.logminer.buffered.memory.MemoryTransaction;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class MemoryLogMinerTransactionCache
extends AbstractLogMinerTransactionCache<MemoryTransaction> {
    private final Map<String, MemoryTransaction> transactionsByTransactionId = new HashMap<String, MemoryTransaction>();
    private final Map<String, List<LogMinerEventEntry>> eventsByTransactionId = new HashMap<String, List<LogMinerEventEntry>>();
    private final Map<String, HashMap<Integer, LogMinerEvent>> eventsByEventIdByTransactionId = new HashMap<String, HashMap<Integer, LogMinerEvent>>();

    @Override
    public MemoryTransaction getTransaction(String transactionId) {
        return this.transactionsByTransactionId.get(transactionId);
    }

    @Override
    public void addTransaction(MemoryTransaction transaction) {
        this.transactionsByTransactionId.put(transaction.getTransactionId(), transaction);
    }

    @Override
    public void removeTransaction(MemoryTransaction transaction) {
        this.transactionsByTransactionId.remove(transaction.getTransactionId());
    }

    @Override
    public boolean containsTransaction(String transactionId) {
        return this.transactionsByTransactionId.containsKey(transactionId);
    }

    @Override
    public boolean isEmpty() {
        return this.transactionsByTransactionId.isEmpty();
    }

    @Override
    public int getTransactionCount() {
        return this.transactionsByTransactionId.size();
    }

    @Override
    public <R> R streamTransactionsAndReturn(Function<Stream<MemoryTransaction>, R> consumer) {
        return consumer.apply(this.transactionsByTransactionId.values().stream());
    }

    @Override
    public void transactions(Consumer<Stream<MemoryTransaction>> consumer) {
        consumer.accept(this.transactionsByTransactionId.values().stream());
    }

    @Override
    public void eventKeys(Consumer<Stream<String>> consumer) {
        consumer.accept(this.eventsByTransactionId.entrySet().stream().flatMap(entry -> {
            String outerKey = (String)entry.getKey();
            return ((List)entry.getValue()).stream().map(LogMinerEventEntry::eventId).map(key -> outerKey + "-" + key);
        }));
    }

    @Override
    public void forEachEvent(MemoryTransaction transaction, LogMinerTransactionCache.InterruptiblePredicate<LogMinerEvent> predicate) throws InterruptedException {
        List<LogMinerEventEntry> events = this.eventsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            try (Stream stream = events.stream();){
                Iterator iterator = stream.iterator();
                while (iterator.hasNext() && predicate.test(((LogMinerEventEntry)iterator.next()).event)) {
                }
            }
        }
    }

    @Override
    public LogMinerEvent getTransactionEvent(MemoryTransaction transaction, int eventKey) {
        HashMap<Integer, LogMinerEvent> eventsByEventId = this.eventsByEventIdByTransactionId.get(transaction.getTransactionId());
        if (eventsByEventId != null) {
            return eventsByEventId.get(eventKey);
        }
        return null;
    }

    @Override
    public MemoryTransaction getAndRemoveTransaction(String transactionId) {
        return this.transactionsByTransactionId.remove(transactionId);
    }

    @Override
    public void addTransactionEvent(MemoryTransaction transaction, int eventKey, LogMinerEvent event) {
        this.eventsByTransactionId.computeIfAbsent(transaction.getTransactionId(), id -> new ArrayList()).add(new LogMinerEventEntry(eventKey, event));
        this.eventsByEventIdByTransactionId.computeIfAbsent(transaction.getTransactionId(), id -> new HashMap()).put(eventKey, event);
    }

    @Override
    public void removeTransactionEvents(MemoryTransaction transaction) {
        this.eventsByTransactionId.remove(transaction.getTransactionId());
        this.eventsByEventIdByTransactionId.remove(transaction.getTransactionId());
    }

    @Override
    public boolean removeTransactionEventWithRowId(MemoryTransaction transaction, String rowId) {
        List<LogMinerEventEntry> events = this.eventsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            for (int i = events.size() - 1; i >= 0; --i) {
                LogMinerEventEntry entry = events.get(i);
                if (!entry.event.getRowId().equals(rowId)) continue;
                events.remove(i);
                this.eventsByEventIdByTransactionId.get(transaction.getTransactionId()).remove(entry.eventId);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsTransactionEvent(MemoryTransaction transaction, int eventKey) {
        HashMap<Integer, LogMinerEvent> eventsByEventId = this.eventsByEventIdByTransactionId.get(transaction.getTransactionId());
        if (eventsByEventId != null) {
            return eventsByEventId.containsKey(eventKey);
        }
        return false;
    }

    @Override
    public int getTransactionEventCount(MemoryTransaction transaction) {
        List<LogMinerEventEntry> events = this.eventsByTransactionId.get(transaction.getTransactionId());
        if (events != null) {
            return events.size();
        }
        return 0;
    }

    @Override
    public int getTransactionEvents() {
        return this.eventsByTransactionId.values().stream().mapToInt(List::size).sum();
    }

    @Override
    public void clear() {
        this.transactionsByTransactionId.clear();
        this.eventsByTransactionId.clear();
        this.eventsByEventIdByTransactionId.clear();
    }

    @Override
    public void syncTransaction(MemoryTransaction transaction) {
    }

    record LogMinerEventEntry(int eventId, LogMinerEvent event) {
    }
}

