/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import java.util.Map;

public class XStreamOracleOffsetContextLoader
implements OffsetContext.Loader<OracleOffsetContext> {
    private final OracleConnectorConfig connectorConfig;

    public XStreamOracleOffsetContextLoader(OracleConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public OracleOffsetContext load(Map<String, ?> offset) {
        return OracleOffsetContext.create().logicalName(this.connectorConfig).scn(this.resolveScn(offset)).lcrPosition(this.loadLcrPosition(offset)).snapshotScn(OracleOffsetContext.loadSnapshotScn(offset)).snapshotPendingTransactions(OracleOffsetContext.loadSnapshotPendingTransactions(offset)).snapshot(this.loadSnapshot(offset).orElse(null)).snapshotCompleted(this.loadSnapshotCompleted(offset)).transactionContext(TransactionContext.load(offset)).incrementalSnapshotContext((IncrementalSnapshotContext<TableId>)SignalBasedIncrementalSnapshotContext.load(offset)).build();
    }

    private Scn resolveScn(Map<String, ?> offset) {
        String lcrPosition = this.loadLcrPosition(offset);
        return lcrPosition != null ? LcrPosition.valueOf(lcrPosition).getScn() : OracleOffsetContext.getScnFromOffsetMapByKey(offset, "scn");
    }

    private String loadLcrPosition(Map<String, ?> offset) {
        return (String)offset.get("lcr_position");
    }
}

