/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.function.Predicates;
import io.debezium.util.Strings;
import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;

@Immutable
public final class Field {
    public static final String INTERNAL_PREFIX = "internal.";
    private static final String EMPTY_STRING = "";
    private static final CharSequence SPACE = " ";
    private final String name;
    private final String displayName;
    private final String desc;
    private final Supplier<Object> defaultValueGenerator;
    private final Validator validator;
    private final ConfigDef.Width width;
    private final ConfigDef.Type type;
    private final ConfigDef.Importance importance;
    private final List<String> dependents;
    private final Recommender recommender;
    private final java.util.Set<?> allowedValues;
    private final GroupEntry group;
    private final boolean isRequired;

    public static Set setOf(Field ... fields) {
        return new Set().with(fields);
    }

    public static Set setOf(Iterable<Field> fields) {
        return new Set().with(fields);
    }

    public static GroupEntry createGroupEntry(Group group) {
        return new GroupEntry(group, 9999);
    }

    public static GroupEntry createGroupEntry(Group group, int positionInGroup) {
        return new GroupEntry(group, positionInGroup);
    }

    public static Field create(String name) {
        return new Field(name, null, null, null, null, null, null, null);
    }

    public static Field createInternal(String name) {
        return new Field(INTERNAL_PREFIX + name, null, null, null, null, null, null, null, null, null);
    }

    public static Field create(String name, String displayName) {
        return new Field(name, displayName, null, null, null, null, null, null);
    }

    public static Field create(String name, String displayName, String description) {
        return new Field(name, displayName, null, null, description, null, null, null);
    }

    public static Field create(String name, String displayName, String description, String defaultValue) {
        return new Field(name, displayName, ConfigDef.Type.STRING, null, description, null, () -> defaultValue, null);
    }

    public static Field create(String name, String displayName, String description, int defaultValue) {
        return new Field(name, displayName, ConfigDef.Type.INT, null, description, null, () -> Integer.toString(defaultValue), null);
    }

    public static Field create(String name, String displayName, String description, long defaultValue) {
        return new Field(name, displayName, ConfigDef.Type.LONG, null, description, null, () -> Long.toString(defaultValue), null);
    }

    public static Field create(String name, String displayName, String description, boolean defaultValue) {
        return new Field(name, displayName, ConfigDef.Type.BOOLEAN, null, description, null, () -> Boolean.toString(defaultValue), null);
    }

    public static Field create(String name, String displayName, String description, Supplier<Object> defaultValueGenerator) {
        return new Field(name, displayName, ConfigDef.Type.STRING, null, description, null, defaultValueGenerator, null);
    }

    public static Field create(String name, String displayName, String description, BooleanSupplier defaultValueGenerator) {
        return new Field(name, displayName, ConfigDef.Type.BOOLEAN, null, description, null, defaultValueGenerator::getAsBoolean, null);
    }

    public static Field create(String name, String displayName, String description, IntSupplier defaultValueGenerator) {
        return new Field(name, displayName, ConfigDef.Type.INT, null, description, null, defaultValueGenerator::getAsInt, null);
    }

    public static Field create(String name, String displayName, String description, LongSupplier defaultValueGenerator) {
        return new Field(name, displayName, ConfigDef.Type.LONG, null, description, null, defaultValueGenerator::getAsLong, null);
    }

    public static ConfigDef group(ConfigDef configDef, String groupName, Field ... fields) {
        block4: {
            if (configDef == null) break block4;
            if (groupName != null) {
                for (int i = 0; i != fields.length; ++i) {
                    Field f = fields[i];
                    configDef.define(f.name(), f.type(), f.defaultValue(), null, f.importance(), f.description(), groupName, i + 1, f.width(), f.displayName(), f.dependents(), null);
                }
            } else {
                for (int i = 0; i != fields.length; ++i) {
                    Field f = fields[i];
                    configDef.define(f.name(), f.type(), f.defaultValue(), null, f.importance(), f.description(), null, 1, f.width(), f.displayName(), f.dependents(), null);
                }
            }
        }
        return configDef;
    }

    protected Field(String name, String displayName, ConfigDef.Type type, ConfigDef.Width width, String description, ConfigDef.Importance importance, Supplier<Object> defaultValueGenerator, Validator validator) {
        this(name, displayName, type, width, description, importance, null, defaultValueGenerator, validator, null);
    }

    protected Field(String name, String displayName, ConfigDef.Type type, ConfigDef.Width width, String description, ConfigDef.Importance importance, List<String> dependents, Supplier<Object> defaultValueGenerator, Validator validator, Recommender recommender) {
        this(name, displayName, type, width, description, importance, dependents, defaultValueGenerator, validator, recommender, false, Field.createGroupEntry(Group.ADVANCED), Collections.emptySet());
    }

    protected Field(String name, String displayName, ConfigDef.Type type, ConfigDef.Width width, String description, ConfigDef.Importance importance, List<String> dependents, Supplier<Object> defaultValueGenerator, Validator validator, Recommender recommender, boolean isRequired, GroupEntry group, java.util.Set<?> allowedValues) {
        Objects.requireNonNull(name, "The field name is required");
        this.name = name;
        this.displayName = displayName;
        this.desc = description;
        this.defaultValueGenerator = defaultValueGenerator != null ? defaultValueGenerator : () -> null;
        this.validator = validator;
        this.type = type != null ? type : ConfigDef.Type.STRING;
        this.width = width != null ? width : ConfigDef.Width.NONE;
        this.importance = importance != null ? importance : ConfigDef.Importance.MEDIUM;
        this.dependents = dependents != null ? dependents : Collections.emptyList();
        this.recommender = recommender;
        this.isRequired = isRequired;
        this.group = group;
        this.allowedValues = allowedValues;
        assert (this.name != null);
    }

    public String name() {
        return this.name;
    }

    public Object defaultValue() {
        return this.defaultValueGenerator.get();
    }

    public String defaultValueAsString() {
        Object defaultValue = this.defaultValue();
        return defaultValue != null ? defaultValue.toString() : null;
    }

    public String description() {
        return this.desc;
    }

    public String displayName() {
        return this.displayName;
    }

    public ConfigDef.Width width() {
        return this.width;
    }

    public ConfigDef.Type type() {
        return this.type;
    }

    public ConfigDef.Importance importance() {
        return this.importance;
    }

    public List<String> dependents() {
        return this.dependents;
    }

    public Validator validator() {
        return this.validator;
    }

    public Recommender recommender() {
        return this.recommender;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public GroupEntry group() {
        return this.group;
    }

    public java.util.Set<?> allowedValues() {
        return this.allowedValues;
    }

    public boolean validate(Configuration config, ValidationOutput problems) {
        Validator typeValidator = Field.validatorForType(this.type);
        int errors = 0;
        if (typeValidator != null) {
            errors += typeValidator.validate(config, this, problems);
        }
        if (this.validator != null) {
            errors += this.validator.validate(config, this, problems);
        }
        return errors == 0;
    }

    protected void validate(Configuration config, Function<String, Field> fieldSupplier, Map<String, ConfigValue> results) {
        ConfigValue value = results.computeIfAbsent(this.name(), ConfigValue::new);
        this.validate(config, (f, v, problem) -> value.addErrorMessage(Field.validationOutput(f, problem)));
        if (this.recommender != null) {
            try {
                value.visible(this.recommender.visible(this, config));
                List<Object> newRecommendations = this.recommender.validValues(this, config);
                List previousRecommendations = value.recommendedValues();
                if (!previousRecommendations.isEmpty()) {
                    newRecommendations.retainAll(previousRecommendations);
                }
                value.recommendedValues(newRecommendations);
            }
            catch (ConfigException e) {
                value.addErrorMessage(e.getMessage());
            }
        }
        this.dependents.forEach(name -> {
            Field dependentField = (Field)fieldSupplier.apply((String)name);
            if (dependentField != null) {
                dependentField.validate(config, fieldSupplier, results);
            }
        });
    }

    public Field withDescription(String description) {
        return new Field(this.name(), this.displayName, this.type(), this.width, description, this.importance(), this.dependents, this.defaultValueGenerator, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDisplayName(String displayName) {
        return new Field(this.name(), displayName, this.type(), this.width, this.description(), this.importance(), this.dependents, this.defaultValueGenerator, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withWidth(ConfigDef.Width width) {
        return new Field(this.name(), this.displayName(), this.type(), width, this.description(), this.importance(), this.dependents, this.defaultValueGenerator, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withType(ConfigDef.Type type) {
        return new Field(this.name(), this.displayName(), type, this.width(), this.description(), this.importance(), this.dependents, this.defaultValueGenerator, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public <T extends Enum<T>> Field withEnum(Class<T> enumType) {
        return this.withEnum(enumType, null);
    }

    public <T extends Enum<T>> Field withEnum(Class<T> enumType, T defaultOption) {
        EnumRecommender<T> recommendator = new EnumRecommender<T>(enumType);
        Field result = this.withType(ConfigDef.Type.STRING).withRecommender(recommendator).withValidation(recommendator).withAllowedValues(Field.getEnumLiterals(enumType));
        if (defaultOption != null) {
            result = defaultOption instanceof EnumeratedValue ? result.withDefault(((EnumeratedValue)((Object)defaultOption)).getValue()) : result.withDefault(defaultOption.name().toLowerCase());
        }
        return result;
    }

    public Field required() {
        return new Field(this.name(), this.displayName(), this.type(), this.width(), this.description(), this.importance, this.dependents, this.defaultValueGenerator, this.validator, this.recommender, true, this.group, this.allowedValues).withValidation(Field::isRequired);
    }

    public Field optional() {
        return new Field(this.name(), this.displayName(), this.type(), this.width(), this.description(), this.importance, this.dependents, this.defaultValueGenerator, this.validator, this.recommender, false, this.group, this.allowedValues);
    }

    public Field withGroup(GroupEntry group) {
        return new Field(this.name(), this.displayName(), this.type(), this.width(), this.description(), this.importance, this.dependents, this.defaultValueGenerator, this.validator, this.recommender, this.isRequired, group, this.allowedValues);
    }

    public Field withAllowedValues(java.util.Set<?> allowedValues) {
        return new Field(this.name(), this.displayName(), this.type(), this.width(), this.description(), this.importance, this.dependents, this.defaultValueGenerator, this.validator, this.recommender, this.isRequired, this.group, allowedValues);
    }

    public Field withImportance(ConfigDef.Importance importance) {
        return new Field(this.name(), this.displayName(), this.type(), this.width(), this.description(), importance, this.dependents, this.defaultValueGenerator, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDependents(String ... dependents) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), Arrays.asList(dependents), this.defaultValueGenerator, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDefault(String defaultValue) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, () -> defaultValue, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDefault(boolean defaultValue) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, () -> defaultValue, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDefault(int defaultValue) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, () -> defaultValue, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDefault(long defaultValue) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, () -> defaultValue, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDefault(BooleanSupplier defaultValueGenerator) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, defaultValueGenerator::getAsBoolean, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDefault(IntSupplier defaultValueGenerator) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, defaultValueGenerator::getAsInt, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withDefault(LongSupplier defaultValueGenerator) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, defaultValueGenerator::getAsLong, this.validator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withRecommender(Recommender recommender) {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, this.defaultValueGenerator, this.validator, recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withInvisibleRecommender() {
        return this.withRecommender(new InvisibleRecommender());
    }

    public Field withNoValidation() {
        return new Field(this.name(), this.displayName(), this.type(), this.width, this.description(), this.importance(), this.dependents, this.defaultValueGenerator, null, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public Field withValidation(Validator ... validators) {
        Validator actualValidator = this.validator;
        for (Validator validator : validators) {
            if (validator == null) continue;
            actualValidator = validator.and(actualValidator);
        }
        return new Field(this.name(), this.displayName(), this.type(), this.width(), this.description(), this.importance(), this.dependents, this.defaultValueGenerator, actualValidator, this.recommender, this.isRequired, this.group, this.allowedValues);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Field) {
            Field that = (Field)obj;
            return this.name().equals(that.name());
        }
        return false;
    }

    public String toString() {
        return this.name();
    }

    private static <T extends Enum<T>> java.util.Set<String> getEnumLiterals(Class<T> enumType) {
        if (Arrays.asList(enumType.getInterfaces()).contains(EnumeratedValue.class)) {
            return Arrays.stream((Enum[])enumType.getEnumConstants()).map(x -> ((EnumeratedValue)((Object)x)).getValue()).map(String::toLowerCase).collect(Collectors.toSet());
        }
        return Arrays.stream((Enum[])enumType.getEnumConstants()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public static Validator validatorForType(ConfigDef.Type type) {
        switch (type) {
            case BOOLEAN: {
                return Field::isBoolean;
            }
            case CLASS: {
                return Field::isClassName;
            }
            case DOUBLE: {
                return Field::isDouble;
            }
            case INT: {
                return Field::isInteger;
            }
            case SHORT: {
                return Field::isShort;
            }
            case LONG: {
                return Field::isLong;
            }
        }
        return null;
    }

    public static int isListOfRegex(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        int errors = 0;
        if (value != null) {
            try {
                Strings.setOfRegex(value, 2);
            }
            catch (PatternSyntaxException e) {
                problems.accept(field, value, "A comma-separated list of valid regular expressions is expected, but " + e.getMessage());
                ++errors;
            }
        }
        return errors;
    }

    public static int isListOfMap(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        int errors = 0;
        if (!Strings.isNullOrBlank(value)) {
            List<String> values = Strings.listOf(value, x -> x.split(","), String::trim);
            for (String v : values) {
                List<String> items = Strings.listOf(v, x -> x.split("="), String::trim);
                if (items.size() == 2) continue;
                problems.accept(field, value, "A equivalent-separated map of valid key/value pairs is expected, for example: k1=v1,k2=v2");
                return ++errors;
            }
        }
        return errors;
    }

    public static int isRegex(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        int errors = 0;
        if (value != null) {
            try {
                Pattern.compile(value, 2);
            }
            catch (PatternSyntaxException e) {
                problems.accept(field, value, "A valid regular expressions is expected, but " + e.getMessage());
                ++errors;
            }
        }
        return errors;
    }

    public static int isClassName(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null || SourceVersion.isName(value)) {
            return 0;
        }
        problems.accept(field, value, "A Java class name is expected");
        return 1;
    }

    public static int isRequired(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value != null && value.trim().length() > 0) {
            return 0;
        }
        problems.accept(field, value, "A value is required");
        return 1;
    }

    public static int isOptional(Configuration config, Field field, ValidationOutput problems) {
        return 0;
    }

    public static int isBoolean(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null || value.trim().equalsIgnoreCase(Boolean.TRUE.toString()) || value.trim().equalsIgnoreCase(Boolean.FALSE.toString())) {
            return 0;
        }
        problems.accept(field, value, "Either 'true' or 'false' is expected");
        return 1;
    }

    public static int isInteger(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            problems.accept(field, value, "An integer is expected");
            return 1;
        }
        return 0;
    }

    public static int isPositiveInteger(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            if (Integer.parseInt(value) > 0) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        problems.accept(field, value, "A positive, non-zero integer value is expected");
        return 1;
    }

    public static int isNonNegativeInteger(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            if (Integer.parseInt(value) >= 0) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        problems.accept(field, value, "An non-negative integer is expected");
        return 1;
    }

    public static int isLong(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            problems.accept(field, value, "A long value is expected");
            return 1;
        }
        return 0;
    }

    public static int isPositiveLong(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            if (Long.parseLong(value) > 0L) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        problems.accept(field, value, "A positive, non-zero long value is expected");
        return 1;
    }

    public static int isNonNegativeLong(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            if (Long.parseLong(value) >= 0L) {
                return 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        problems.accept(field, value, "A non-negative long value is expected");
        return 1;
    }

    public static int isShort(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            problems.accept(field, value, "A short value is expected");
            return 1;
        }
        return 0;
    }

    public static int isDouble(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            problems.accept(field, value, "A double value is expected");
            return 1;
        }
        return 0;
    }

    public static int isZoneOffset(Configuration config, Field field, ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        try {
            ZoneOffset.of(value);
        }
        catch (DateTimeException e) {
            problems.accept(field, value, "A zone offset string representation is expected");
            return 1;
        }
        return 0;
    }

    public static int notContainEmptyElements(Configuration config, Field field, ValidationOutput problems) {
        if (!config.hasKey(field)) {
            return 0;
        }
        List<String> values = config.getList(field);
        if (values.contains(EMPTY_STRING)) {
            problems.accept(field, values, "Empty string element(s) not permitted");
            return 1;
        }
        return 0;
    }

    public static int notContainSpaceInAnyElement(Configuration config, Field field, ValidationOutput problems) {
        if (!config.hasKey(field)) {
            return 0;
        }
        List<String> values = config.getList(field);
        if (values.stream().anyMatch(h -> h.contains(SPACE))) {
            problems.accept(field, values, "Element(s) containing space not permitted");
            return 1;
        }
        return 0;
    }

    public static String validationOutput(Field field, String problem) {
        return String.format("The '%s' value is invalid: %s", field.name(), problem);
    }

    @Immutable
    public static final class Set
    implements Iterable<Field> {
        private final Map<String, Field> fieldsByName;

        private Set() {
            this.fieldsByName = Collections.emptyMap();
        }

        private Set(Collection<Field> fields) {
            LinkedHashMap all = new LinkedHashMap();
            fields.forEach(field -> {
                if (field != null) {
                    all.put(field.name(), field);
                }
            });
            this.fieldsByName = Collections.unmodifiableMap(all);
        }

        public Field fieldWithName(String name) {
            return this.fieldsByName.get(name);
        }

        @Override
        public Iterator<Field> iterator() {
            return this.fieldsByName.values().iterator();
        }

        public Field[] asArray() {
            return this.fieldsByName.values().toArray(new Field[0]);
        }

        public void forEachMissingDependent(Consumer<String> consumer) {
            this.fieldsByName.values().stream().map(Field::dependents).flatMap(Collection::stream).filter(Predicates.not(this.fieldsByName::containsKey)).forEach(consumer);
        }

        public void forEachTopLevelField(Consumer<Field> consumer) {
            Collection namesOfDependents = this.fieldsByName.values().stream().map(Field::dependents).flatMap(Collection::stream).collect(Collectors.toSet());
            this.fieldsByName.values().stream().filter(f -> !namesOfDependents.contains(f.name())).forEach(consumer);
        }

        public Set with(Field ... fields) {
            if (fields.length == 0) {
                return this;
            }
            LinkedHashSet<Field> all = new LinkedHashSet<Field>(this.fieldsByName.values());
            for (Field f : fields) {
                if (f == null) continue;
                all.add(f);
            }
            return new Set(all);
        }

        public Set with(Iterable<Field> fields) {
            LinkedHashSet<Field> all = new LinkedHashSet<Field>(this.fieldsByName.values());
            fields.forEach(field -> {
                if (field != null) {
                    all.add((Field)field);
                }
            });
            return new Set(all);
        }

        public java.util.Set<String> allFieldNames() {
            return this.fieldsByName.keySet();
        }

        public Set filtered(Predicate<Field> filter) {
            LinkedHashSet<Field> filtered = new LinkedHashSet<Field>();
            for (Map.Entry<String, Field> field : this.fieldsByName.entrySet()) {
                if (!filter.test(field.getValue())) continue;
                filtered.add(field.getValue());
            }
            return new Set(filtered);
        }
    }

    public static class GroupEntry {
        private final Group group;
        private final int positionInGroup;

        GroupEntry(Group group, int positionInGroup) {
            this.group = group;
            this.positionInGroup = positionInGroup;
        }

        public Group getGroup() {
            return this.group;
        }

        public int getPositionInGroup() {
            return this.positionInGroup;
        }
    }

    public static enum Group {
        CONNECTION,
        CONNECTION_ADVANCED_SSL,
        CONNECTION_ADVANCED,
        CONNECTION_ADVANCED_REPLICATION,
        CONNECTION_ADVANCED_PUBLICATION,
        FILTERS,
        CONNECTOR_SNAPSHOT,
        CONNECTOR,
        ADVANCED_HEARTBEAT,
        CONNECTOR_ADVANCED,
        ADVANCED;

    }

    @FunctionalInterface
    public static interface Validator {
        public int validate(Configuration var1, Field var2, ValidationOutput var3);

        default public Validator and(Validator other) {
            if (other == null || other == this) {
                return this;
            }
            return (config, field, problems) -> this.validate(config, field, problems) + other.validate(config, field, problems);
        }
    }

    public static interface Recommender {
        public List<Object> validValues(Field var1, Configuration var2);

        public boolean visible(Field var1, Configuration var2);
    }

    @FunctionalInterface
    public static interface ValidationOutput {
        public void accept(Field var1, Object var2, String var3);
    }

    public static class EnumRecommender<T extends Enum<T>>
    implements Recommender,
    Validator {
        private final List<Object> validValues;
        private final java.util.Set<String> literals;
        private final String literalsStr;

        public EnumRecommender(Class<T> enumType) {
            this.literals = Field.getEnumLiterals(enumType);
            this.validValues = Collections.unmodifiableList(new ArrayList<String>(this.literals));
            this.literalsStr = Strings.join((CharSequence)", ", this.validValues);
        }

        @Override
        public List<Object> validValues(Field field, Configuration config) {
            return this.validValues;
        }

        @Override
        public boolean visible(Field field, Configuration config) {
            return true;
        }

        @Override
        public int validate(Configuration config, Field field, ValidationOutput problems) {
            String value = config.getString(field);
            if (value == null) {
                problems.accept(field, value, "Value must be one of " + this.literalsStr);
                return 1;
            }
            String trimmed = value.trim().toLowerCase();
            if (!this.literals.contains(trimmed)) {
                problems.accept(field, value, "Value must be one of " + this.literalsStr);
                return 1;
            }
            return 0;
        }
    }

    public static class InvisibleRecommender
    implements Recommender {
        @Override
        public List<Object> validValues(Field field, Configuration config) {
            return new LinkedList<Object>();
        }

        @Override
        public boolean visible(Field field, Configuration config) {
            return false;
        }
    }

    public static class OneOfRecommender
    implements Recommender {
        protected final List<String> possibleNames;

        public OneOfRecommender(String ... possibleNames) {
            this(Arrays.asList(possibleNames));
        }

        public OneOfRecommender(List<String> possibleNames) {
            this.possibleNames = possibleNames;
        }

        @Override
        public List<Object> validValues(Field field, Configuration config) {
            return new LinkedList<Object>();
        }

        @Override
        public boolean visible(Field field, Configuration config) {
            for (String possibleName : this.possibleNames) {
                String value = config.getString(possibleName);
                if (value == null) continue;
                return possibleName.equals(field.name());
            }
            return true;
        }
    }

    public static class RangeValidator
    implements Validator {
        private final Number min;
        private final Number max;

        private RangeValidator(Number min, Number max) {
            this.min = min;
            this.max = max;
        }

        public static RangeValidator atLeast(Number min) {
            return new RangeValidator(min, null);
        }

        public static RangeValidator between(Number min, Number max) {
            return new RangeValidator(min, max);
        }

        @Override
        public int validate(Configuration config, Field field, ValidationOutput problems) {
            Number value = config.getNumber(field);
            if (value == null) {
                problems.accept(field, value, "A value must be provided");
                return 1;
            }
            if (this.min != null && value.doubleValue() < this.min.doubleValue()) {
                problems.accept(field, value, "Value must be at least " + String.valueOf(this.min));
                return 1;
            }
            if (this.max != null && value.doubleValue() > this.max.doubleValue()) {
                problems.accept(field, value, "Value must be no more than " + String.valueOf(this.max));
                return 1;
            }
            return 0;
        }

        public void ensureValid(String name, Object o) {
            if (o == null) {
                throw new ConfigException(name, o, "Value must be non-null");
            }
            Number n = (Number)o;
            if (this.min != null && n.doubleValue() < this.min.doubleValue()) {
                throw new ConfigException(name, o, "Value must be at least " + String.valueOf(this.min));
            }
            if (this.max != null && n.doubleValue() > this.max.doubleValue()) {
                throw new ConfigException(name, o, "Value must be no more than " + String.valueOf(this.max));
            }
        }

        public String toString() {
            if (this.min == null) {
                return "[...," + String.valueOf(this.max) + "]";
            }
            if (this.max == null) {
                return "[" + String.valueOf(this.min) + ",...]";
            }
            return "[" + String.valueOf(this.min) + ",...," + String.valueOf(this.max) + "]";
        }
    }
}

