/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Attribute;
import io.debezium.relational.AttributeEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

final class AttributeImpl
implements Attribute {
    private final String name;
    private final String value;

    AttributeImpl(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public Integer asInteger() {
        return this.value == null ? null : Integer.valueOf(Integer.parseInt(this.value));
    }

    @Override
    public Long asLong() {
        return this.value == null ? null : Long.valueOf(Long.parseLong(this.value));
    }

    @Override
    public Boolean asBoolean() {
        return this.value == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.value));
    }

    @Override
    public BigInteger asBigInteger() {
        return this.value == null ? null : new BigInteger(this.value);
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this.value == null ? null : new BigDecimal(this.value);
    }

    @Override
    public Float asFloat() {
        return this.value == null ? null : Float.valueOf(Float.parseFloat(this.value));
    }

    @Override
    public Double asDouble() {
        return this.value == null ? null : Double.valueOf(Double.parseDouble(this.value));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Attribute) {
            AttributeImpl attribute = (AttributeImpl)obj;
            return Objects.equals(this.name, attribute.name) && Objects.equals(this.value, attribute.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return "name='" + this.name + "', value='" + this.value + "'";
    }

    @Override
    public AttributeEditor edit() {
        return Attribute.editor().name(this.name()).value(this.value());
    }
}

