/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.embedded.ConverterBuilder;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.ChangeEventFormat;
import io.debezium.engine.format.KeyValueChangeEventFormat;
import io.debezium.engine.format.KeyValueHeaderChangeEventFormat;
import io.debezium.engine.spi.OffsetCommitPolicy;
import java.io.IOException;
import java.time.Clock;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.HeaderConverter;

public class ConvertingEngineBuilder<R>
implements DebeziumEngine.Builder<R> {
    private final DebeziumEngine.Builder<SourceRecord> delegate = new EmbeddedEngine.EngineBuilder();
    private final ConverterBuilder converterBuilder = new ConverterBuilder();
    private Function<SourceRecord, R> toFormat;
    private Function<R, SourceRecord> fromFormat;

    ConvertingEngineBuilder(ChangeEventFormat<?> format) {
        this(KeyValueHeaderChangeEventFormat.of(null, (Class)format.getValueFormat(), null));
    }

    ConvertingEngineBuilder(KeyValueChangeEventFormat<?, ?> format) {
        this(format instanceof KeyValueHeaderChangeEventFormat ? (KeyValueHeaderChangeEventFormat)format : KeyValueHeaderChangeEventFormat.of((Class)format.getKeyFormat(), (Class)format.getValueFormat(), null));
    }

    ConvertingEngineBuilder(KeyValueHeaderChangeEventFormat<?, ?, ?> format) {
        this.converterBuilder.using(format);
    }

    public DebeziumEngine.Builder<R> notifying(Consumer<R> consumer) {
        this.delegate.notifying(record -> consumer.accept(this.toFormat.apply((SourceRecord)record)));
        return this;
    }

    public DebeziumEngine.Builder<R> notifying(DebeziumEngine.ChangeConsumer<R> handler) {
        this.delegate.notifying((DebeziumEngine.ChangeConsumer)new ConvertingChangeConsumer(handler));
        return this;
    }

    public DebeziumEngine.Builder<R> using(Properties config) {
        this.converterBuilder.using(config);
        this.delegate.using(config);
        return this;
    }

    public DebeziumEngine.Builder<R> using(ClassLoader classLoader) {
        this.delegate.using(classLoader);
        return this;
    }

    public DebeziumEngine.Builder<R> using(Clock clock) {
        this.delegate.using(clock);
        return this;
    }

    public DebeziumEngine.Builder<R> using(DebeziumEngine.CompletionCallback completionCallback) {
        this.delegate.using(completionCallback);
        return this;
    }

    public DebeziumEngine.Builder<R> using(DebeziumEngine.ConnectorCallback connectorCallback) {
        this.delegate.using(connectorCallback);
        return this;
    }

    public DebeziumEngine.Builder<R> using(OffsetCommitPolicy policy) {
        this.delegate.using(policy);
        return this;
    }

    public DebeziumEngine<R> build() {
        final DebeziumEngine engine = this.delegate.build();
        final HeaderConverter headerConverter = this.converterBuilder.headerConverter();
        this.toFormat = this.converterBuilder.toFormat(headerConverter);
        this.fromFormat = this.converterBuilder.fromFormat();
        return new DebeziumEngine<R>(){

            public void run() {
                engine.run();
            }

            public void close() throws IOException {
                if (headerConverter != null) {
                    headerConverter.close();
                }
                engine.close();
            }
        };
    }

    private class ConvertingChangeConsumer
    implements DebeziumEngine.ChangeConsumer<SourceRecord> {
        private final DebeziumEngine.ChangeConsumer<R> handler;

        private ConvertingChangeConsumer(DebeziumEngine.ChangeConsumer<R> handler) {
            this.handler = handler;
        }

        public void handleBatch(List<SourceRecord> records, final DebeziumEngine.RecordCommitter<SourceRecord> committer) throws InterruptedException {
            this.handler.handleBatch(records.stream().map(x -> ConvertingEngineBuilder.this.toFormat.apply((SourceRecord)x)).collect(Collectors.toList()), new DebeziumEngine.RecordCommitter<R>(){

                public void markProcessed(R record) throws InterruptedException {
                    committer.markProcessed((Object)ConvertingEngineBuilder.this.fromFormat.apply(record));
                }

                public void markBatchFinished() throws InterruptedException {
                    committer.markBatchFinished();
                }

                public void markProcessed(R record, DebeziumEngine.Offsets sourceOffsets) throws InterruptedException {
                    committer.markProcessed((Object)ConvertingEngineBuilder.this.fromFormat.apply(record), sourceOffsets);
                }

                public DebeziumEngine.Offsets buildOffsets() {
                    return committer.buildOffsets();
                }
            });
        }

        public boolean supportsTombstoneEvents() {
            return this.handler.supportsTombstoneEvents();
        }
    }
}

