/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.SqlSessionFactoryBeanExt;
import com.gitee.fastmybatis.core.ext.spi.SpiContext;
import com.gitee.fastmybatis.core.ext.transaction.TransactionTemplateManager;
import com.gitee.fastmybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import com.gitee.fastmybatis.spring.boot.autoconfigure.MybatisProperties;
import com.gitee.fastmybatis.spring.boot.autoconfigure.SpringBootVFS;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.ConditionalOnSingleDatasource;
import com.gitee.fastmybatis.spring.boot.autoconfigure.util.FillUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnSingleDatasource
@EnableConfigurationProperties(value={MybatisProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class MybatisAutoConfiguration
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MybatisAutoConfiguration.class);
    private final MybatisProperties properties;
    private final Interceptor[] interceptors;
    private final ResourceLoader resourceLoader;
    private final DatabaseIdProvider databaseIdProvider;
    private final List<ConfigurationCustomizer> configurationCustomizers;
    private static ThreadLocal<Collection<String>> packageList = new ThreadLocal();
    private final ApplicationContext applicationContext;
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    public MybatisAutoConfiguration(MybatisProperties properties, ObjectProvider<Interceptor[]> interceptorsProvider, ResourceLoader resourceLoader, ObjectProvider<DatabaseIdProvider> databaseIdProvider, ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider, ApplicationContext applicationContext) {
        this.properties = properties;
        this.interceptors = (Interceptor[])interceptorsProvider.getIfAvailable();
        this.resourceLoader = resourceLoader;
        this.databaseIdProvider = (DatabaseIdProvider)databaseIdProvider.getIfAvailable();
        this.configurationCustomizers = (List)configurationCustomizersProvider.getIfAvailable();
        this.applicationContext = applicationContext;
        FastmybatisConfig.ignoreEmptyString = properties.isIgnoreEmptyString();
        FastmybatisConfig.emptyStringWithTrim = properties.isEmptyStringWithTrim();
        FastmybatisConfig.ignoreEmptyArray = properties.isIgnoreEmptyArray();
        FastmybatisConfig.PRINT_SQL = properties.isPrintSql();
        FastmybatisConfig.DISABLE_JOIN_SQL_IN_QUERY = properties.isDisableJoinSqlInQuery();
        FastmybatisConfig.setIgnoreQueryWhenMissingCondition((boolean)properties.getIgnoreQueryWhenMissingCondition());
    }

    public void checkConfigFileExists() {
        if (this.properties.isCheckConfigLocation() && StringUtils.hasText((String)this.properties.getConfigLocation())) {
            Resource resource = this.resourceLoader.getResource(this.properties.getConfigLocation());
            Assert.state((boolean)resource.exists(), (String)("Cannot find config location: " + resource + " (please add config file or check your Mybatis configuration)"));
        }
    }

    public void afterPropertiesSet() throws Exception {
        TransactionTemplateManager.addMainTransactionManager((PlatformTransactionManager)this.platformTransactionManager);
        this.checkConfigFileExists();
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource, FastmybatisConfig fastmybatisConfig) throws Exception {
        String basePackage;
        org.apache.ibatis.session.Configuration configuration;
        SqlSessionFactoryBeanExt factory = new SqlSessionFactoryBeanExt();
        factory.setDataSource(dataSource);
        factory.setVfs(SpringBootVFS.class);
        if (StringUtils.hasText((String)this.properties.getConfigLocation())) {
            factory.setConfigLocation(this.resourceLoader.getResource(this.properties.getConfigLocation()));
        }
        if ((configuration = this.properties.getConfiguration()) == null && !StringUtils.hasText((String)this.properties.getConfigLocation())) {
            configuration = new org.apache.ibatis.session.Configuration();
        }
        if (configuration != null && !CollectionUtils.isEmpty(this.configurationCustomizers)) {
            for (ConfigurationCustomizer customizer : this.configurationCustomizers) {
                customizer.customize(configuration);
            }
        }
        factory.setConfiguration(configuration);
        if (this.properties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(this.properties.getConfigurationProperties());
        }
        if (!ObjectUtils.isEmpty((Object[])this.interceptors)) {
            factory.setPlugins(this.interceptors);
        }
        if (this.databaseIdProvider != null) {
            factory.setDatabaseIdProvider(this.databaseIdProvider);
        }
        if (StringUtils.hasLength((String)this.properties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
        }
        if (StringUtils.hasLength((String)this.properties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(this.properties.getTypeHandlersPackage());
        }
        if (!ObjectUtils.isEmpty((Object[])this.properties.resolveMapperLocations())) {
            factory.setMapperLocations(this.properties.resolveMapperLocations());
        }
        if (StringUtils.isEmpty((Object)(basePackage = this.properties.getBasePackage()))) {
            basePackage = StringUtils.collectionToDelimitedString(packageList.get(), (String)",");
        }
        factory.setBasePackage(basePackage);
        factory.setConfig(fastmybatisConfig);
        factory.setApplicationContext(this.applicationContext);
        return factory.getObject();
    }

    @Bean
    @ConditionalOnMissingBean
    public FastmybatisConfig fastmybatisConfig() {
        FastmybatisConfig config = new FastmybatisConfig();
        SpiContext.getBeanExecutor().copyPropertiesIgnoreNull((Object)this.properties, (Object)config);
        if (this.properties.getFill() != null) {
            config.setFills(FillUtil.buildFills(this.properties.getFill()));
        }
        return config;
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        ExecutorType executorType = this.properties.getExecutorType();
        if (executorType != null) {
            return new SqlSessionTemplate(sqlSessionFactory, executorType);
        }
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Configuration
    @Import(value={AutoConfiguredMapperScannerRegistrar.class})
    @ConditionalOnMissingBean(value={MapperFactoryBean.class})
    @ConditionalOnSingleDatasource
    public static class MapperScannerRegistrarNotFoundConfiguration
    implements InitializingBean {
        @Autowired
        private ApplicationContext applicationContext;

        public void afterPropertiesSet() {
            logger.debug("No {} found.", (Object)MapperFactoryBean.class.getName());
        }
    }

    public static class AutoConfiguredMapperScannerRegistrar
    implements BeanFactoryAware,
    ImportBeanDefinitionRegistrar,
    ResourceLoaderAware,
    EnvironmentAware {
        private BeanFactory beanFactory;
        private ResourceLoader resourceLoader;
        private Environment environment;

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            logger.debug("Searching for mappers annotated with @Mapper");
            ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
            try {
                if (this.resourceLoader != null) {
                    scanner.setResourceLoader(this.resourceLoader);
                }
                Collection packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
                String basePackage = this.environment.getProperty("mybatis.base-package");
                if (StringUtils.hasText((String)basePackage)) {
                    String[] packageArr;
                    for (String pkg : packageArr = basePackage.split(";|,")) {
                        packages.add(pkg);
                    }
                    packages = new HashSet(packages);
                }
                if (logger.isDebugEnabled()) {
                    for (String pkg : packages) {
                        logger.debug("Using auto-configuration base package '{}'", (Object)pkg);
                    }
                }
                scanner.setMarkerInterface(com.gitee.fastmybatis.core.mapper.Mapper.class);
                scanner.setAnnotationClass(Mapper.class);
                scanner.registerFilters();
                scanner.doScan(StringUtils.toStringArray((Collection)packages));
                packageList.set(packages);
            }
            catch (IllegalStateException ex) {
                logger.debug("Could not determine auto-configuration package, automatic mapper scanning disabled.", (Throwable)ex);
            }
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }
    }
}

