/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure.multi;

import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceCreator;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceProp;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DruidDataSourceCreator;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.HikariDataSourceCreator;
import javax.sql.DataSource;
import org.springframework.util.ClassUtils;

public class DataSourceBuilder {
    private static final String[] DATASOURCE_LIST = new String[]{"com.zaxxer.hikari.HikariDataSource", "com.alibaba.druid.pool.DruidDataSource"};
    private DataSourceProp datasource;

    public static DataSourceBuilder builder(DataSourceProp datasource) {
        DataSourceBuilder builder = new DataSourceBuilder();
        builder.datasource = datasource;
        return builder;
    }

    public DataSource build() {
        Class<? extends DataSource> type = this.datasource.getType();
        if (type != null) {
            DataSourceCreator sourceCreator = this.getDataCreator(type);
            return sourceCreator.create(this.datasource);
        }
        for (String dataSourceClass : DATASOURCE_LIST) {
            Class<?> cls = this.findClass(dataSourceClass);
            if (cls == null) continue;
            DataSourceCreator sourceCreator = this.getDataCreator(cls);
            return sourceCreator.create(this.datasource);
        }
        throw new IllegalStateException("\u627e\u4e0d\u5230\u6570\u636e\u6e90");
    }

    private DataSourceCreator getDataCreator(Class<?> type) {
        String className;
        switch (className = type.getName()) {
            case "com.zaxxer.hikari.HikariDataSource": {
                return new HikariDataSourceCreator();
            }
            case "com.alibaba.druid.pool.DruidDataSource": {
                return new DruidDataSourceCreator();
            }
        }
        throw new IllegalStateException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90:" + className);
    }

    private Class<?> findClass(String name) {
        try {
            return ClassUtils.forName((String)name, null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

