/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure.multi;

import com.alibaba.druid.pool.DruidDataSource;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceCreator;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceProp;
import javax.sql.DataSource;

public class DruidDataSourceCreator
implements DataSourceCreator {
    @Override
    public DataSource create(DataSourceProp dataSourceProp) {
        long connectionTimeout = dataSourceProp.getConnectionTimeout();
        long validationTimeout = dataSourceProp.getValidationTimeout();
        int maxPoolSize = dataSourceProp.getMaxPoolSize();
        int minIdle = dataSourceProp.getMinIdle();
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setDriverClassName(dataSourceProp.getDriverClassName());
        druidDataSource.setUrl(dataSourceProp.getUrl());
        druidDataSource.setUsername(dataSourceProp.getUsername());
        druidDataSource.setPassword(dataSourceProp.getPassword());
        if (connectionTimeout > 0L) {
            druidDataSource.setConnectTimeout((int)connectionTimeout);
        }
        if (validationTimeout > 0L) {
            druidDataSource.setValidationQueryTimeout((int)validationTimeout);
        }
        if (minIdle > 0) {
            druidDataSource.setMinIdle(minIdle);
        }
        if (maxPoolSize > 0) {
            druidDataSource.setMaxActive(maxPoolSize);
        }
        return druidDataSource;
    }
}

