/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure.multi;

import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceCreator;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceProp;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;

public class HikariDataSourceCreator
implements DataSourceCreator {
    @Override
    public DataSource create(DataSourceProp dataSourceProp) {
        long maxLifetime;
        long leakDetectionThreshold;
        long idleTimeout;
        long connectionTimeout = dataSourceProp.getConnectionTimeout();
        long validationTimeout = dataSourceProp.getValidationTimeout();
        int maxPoolSize = dataSourceProp.getMaxPoolSize();
        int minIdle = dataSourceProp.getMinIdle();
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(dataSourceProp.getDriverClassName());
        hikariConfig.setJdbcUrl(dataSourceProp.getUrl());
        hikariConfig.setUsername(dataSourceProp.getUsername());
        hikariConfig.setPassword(dataSourceProp.getPassword());
        if (connectionTimeout > 0L) {
            hikariConfig.setConnectionTimeout(connectionTimeout);
        }
        if (validationTimeout > 0L) {
            hikariConfig.setValidationTimeout(validationTimeout);
        }
        if ((idleTimeout = dataSourceProp.getIdleTimeout()) > 0L) {
            hikariConfig.setIdleTimeout(idleTimeout);
        }
        if ((leakDetectionThreshold = dataSourceProp.getLeakDetectionThreshold()) > 0L) {
            hikariConfig.setLeakDetectionThreshold(leakDetectionThreshold);
        }
        if ((maxLifetime = dataSourceProp.getMaxLifetime()) > 0L) {
            hikariConfig.setMaxLifetime(maxLifetime);
        }
        if (maxPoolSize > 0) {
            hikariConfig.setMaximumPoolSize(maxPoolSize);
        }
        if (minIdle > 0) {
            hikariConfig.setMinimumIdle(minIdle);
        }
        return new HikariDataSource(hikariConfig);
    }
}

