/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure.multi;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.MybatisContext;
import com.gitee.fastmybatis.core.ext.SqlSessionFactoryBeanExt;
import com.gitee.fastmybatis.core.ext.spi.SpiContext;
import com.gitee.fastmybatis.core.ext.transaction.AliasTransactionTemplate;
import com.gitee.fastmybatis.core.ext.transaction.TransactionTemplateManager;
import com.gitee.fastmybatis.core.support.plugin.SqlFormatterPlugin;
import com.gitee.fastmybatis.core.util.ClassUtil;
import com.gitee.fastmybatis.spring.boot.autoconfigure.MybatisProperties;
import com.gitee.fastmybatis.spring.boot.autoconfigure.SpringBootVFS;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceBuilder;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceProp;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DatasourcePropContext;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.MultiDataSourceContext;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.MultiDataSourceProps;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.MyBatisComponent;
import com.gitee.fastmybatis.spring.boot.autoconfigure.util.FillUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MapperScannerRegistrar
implements BeanFactoryAware,
ResourceLoaderAware,
EnvironmentAware,
ImportBeanDefinitionRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(MapperScannerRegistrar.class);
    private BeanFactory beanFactory;
    private ResourceLoader resourceLoader;
    private Environment environment;
    private BeanDefinitionRegistry beanDefinitionRegistry;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.beanDefinitionRegistry = registry;
        this.doRegisterBeanDefinitions(registry);
    }

    private void doRegisterBeanDefinitions(BeanDefinitionRegistry registry) {
        MultiDataSourceProps multiDataSourceProps = this.buildMultiDataSourceProps(this.environment);
        for (Map.Entry<String, DataSourceProp> entry : multiDataSourceProps.getMultiDatasource().entrySet()) {
            String dsAlias = entry.getKey();
            DataSourceProp prop = entry.getValue();
            DatasourcePropContext datasourcePropContext = DatasourcePropContext.of(entry);
            MyBatisComponent myBatisComponent = this.buildMyBatisComponent(dsAlias, datasourcePropContext);
            this.cacheComponent(myBatisComponent);
            MultiDataSourceContext.setMyBatisComponent(dsAlias, myBatisComponent);
            String basePackage = prop.getMybatis().getBasePackage();
            logger.debug("Searching for mappers annotated with @Mapper, package is {}", (Object)basePackage);
            HashSet<String> packages = new HashSet<String>();
            ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
            if (this.resourceLoader != null) {
                scanner.setResourceLoader(this.resourceLoader);
            }
            scanner.setSqlSessionTemplate(myBatisComponent.getSqlSessionTemplate());
            if (StringUtils.hasText((String)basePackage)) {
                String[] packageArr = basePackage.split(";|,");
                packages.addAll(Arrays.asList(packageArr));
            }
            if (logger.isDebugEnabled()) {
                for (String pkg : packages) {
                    logger.debug("Using auto-configuration base package '{}'", (Object)pkg);
                }
            }
            scanner.setMarkerInterface(com.gitee.fastmybatis.core.mapper.Mapper.class);
            scanner.setAnnotationClass(Mapper.class);
            scanner.registerFilters();
            scanner.doScan(StringUtils.toStringArray(packages));
        }
    }

    private MyBatisComponent buildMyBatisComponent(String dsAlias, DatasourcePropContext datasourcePropContext) {
        DataSourceProp dataSourceProp = datasourcePropContext.getDataSourceProp();
        this.checkDatasource(dsAlias, dataSourceProp);
        logger.info("\u521d\u59cb\u5316\u6570\u636e\u6e90:{}, url={}", (Object)dsAlias, (Object)dataSourceProp.getUrl());
        DataSource dataSource = DataSourceBuilder.builder(dataSourceProp).build();
        SqlSessionFactory sqlSessionFactory = this.buildSqlSessionFactory(dataSourceProp, dataSource, null);
        SqlSessionTemplate sqlSessionTemplate = this.buildSqlSessionTemplate(dataSourceProp, sqlSessionFactory);
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
        AliasTransactionTemplate transactionTemplate = new AliasTransactionTemplate(dsAlias, (PlatformTransactionManager)transactionManager);
        return new MyBatisComponent(datasourcePropContext, dataSource, transactionManager, sqlSessionFactory, sqlSessionTemplate, transactionTemplate);
    }

    private void cacheComponent(MyBatisComponent component) {
        DatasourcePropContext datasourcePropContext = component.getDatasourcePropContext();
        MybatisContext.addSqlSessionFactory((String)datasourcePropContext.getDsAlias(), (SqlSessionFactory)component.getSqlSessionFactory(), (boolean)datasourcePropContext.isMain());
        TransactionTemplateManager.addTransactionTemplate((AliasTransactionTemplate)component.getTransactionTemplate());
        if (datasourcePropContext.getDataSourceProp().getMain().booleanValue()) {
            TransactionTemplateManager.addMainTransactionManager((PlatformTransactionManager)component.getTransactionManager());
        }
    }

    private SqlSessionFactory buildSqlSessionFactory(DataSourceProp dataSourceProp, DataSource existDataSource, ApplicationContext applicationContext) {
        SqlSessionFactoryBeanExt sessionFactoryBeanExt = this.buildSqlSessionFactoryBean(dataSourceProp, existDataSource, applicationContext);
        try {
            return sessionFactoryBeanExt.getObject();
        }
        catch (Exception e) {
            logger.error("Create SqlSessionFactory error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private SqlSessionFactoryBeanExt buildSqlSessionFactoryBean(DataSourceProp dataSourceProp, DataSource existDataSource, ApplicationContext applicationContext) {
        Configuration configuration;
        MybatisProperties mybatisProperties = dataSourceProp.getMybatis();
        SqlSessionFactoryBeanExt factory = new SqlSessionFactoryBeanExt();
        DataSource dataSource = existDataSource != null ? existDataSource : DataSourceBuilder.builder(dataSourceProp).build();
        factory.setDataSource(dataSource);
        factory.setVfs(SpringBootVFS.class);
        if (StringUtils.hasText((String)mybatisProperties.getConfigLocation())) {
            factory.setConfigLocation(this.resourceLoader.getResource(mybatisProperties.getConfigLocation()));
        }
        if ((configuration = mybatisProperties.getConfiguration()) == null && !StringUtils.hasText((String)mybatisProperties.getConfigLocation())) {
            configuration = new Configuration();
        }
        factory.setConfiguration(configuration);
        if (mybatisProperties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(mybatisProperties.getConfigurationProperties());
        }
        if (StringUtils.hasLength((String)mybatisProperties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(mybatisProperties.getTypeAliasesPackage());
        }
        if (StringUtils.hasLength((String)mybatisProperties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(mybatisProperties.getTypeHandlersPackage());
        }
        if (!ObjectUtils.isEmpty((Object[])mybatisProperties.resolveMapperLocations())) {
            factory.setMapperLocations(mybatisProperties.resolveMapperLocations());
        }
        List<Class<? extends Interceptor>> pluginsList = mybatisProperties.getPlugins();
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        if (!ObjectUtils.isEmpty(pluginsList)) {
            List interceptorList = pluginsList.stream().map(aClass -> (Interceptor)ClassUtil.newInstance((Class)aClass)).collect(Collectors.toList());
            interceptors.addAll(interceptorList);
        }
        if (mybatisProperties.isPrintSql()) {
            this.enableSqlFormatPlugin(interceptors);
        }
        Interceptor[] pluginArr = interceptors.toArray(new Interceptor[0]);
        factory.setPlugins(pluginArr);
        String basePackage = mybatisProperties.getBasePackage();
        factory.setBasePackage(basePackage);
        factory.setConfig(this.fastmybatisConfig(mybatisProperties));
        factory.setApplicationContext(applicationContext);
        return factory;
    }

    private void enableSqlFormatPlugin(List<Interceptor> plugins) {
        Optional<Interceptor> first = plugins.stream().filter(data -> data instanceof SqlFormatterPlugin).findFirst();
        if (first.isPresent()) {
            SqlFormatterPlugin interceptor = (SqlFormatterPlugin)first.get();
            interceptor.setEnable(true);
        } else {
            SqlFormatterPlugin interceptor = new SqlFormatterPlugin();
            interceptor.setEnable(true);
            plugins.add((Interceptor)interceptor);
        }
    }

    private FastmybatisConfig fastmybatisConfig(MybatisProperties properties) {
        FastmybatisConfig config = new FastmybatisConfig();
        SpiContext.getBeanExecutor().copyPropertiesIgnoreNull((Object)properties, (Object)config);
        if (properties.getFill() != null) {
            config.setFills(FillUtil.buildFills(properties.getFill()));
        }
        return config;
    }

    private SqlSessionTemplate buildSqlSessionTemplate(DataSourceProp dataSourceProp, SqlSessionFactory sqlSessionFactory) {
        ExecutorType executorType = dataSourceProp.getMybatis().getExecutorType();
        if (executorType != null) {
            return new SqlSessionTemplate(sqlSessionFactory, executorType);
        }
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    private void checkDatasource(String dbAlias, DataSourceProp dataSourceProp) {
        String prefix = "spring.multi-datasource." + dbAlias + ".";
        this.checkNotBlank(prefix + "url", dataSourceProp.getUrl());
        this.checkNotBlank(prefix + "driver-class-name", dataSourceProp.getDriverClassName());
        this.checkNotBlank(prefix + "username", dataSourceProp.getUsername());
        this.checkNotBlank(prefix + "password", dataSourceProp.getPassword());
        MybatisProperties mybatisProperties = dataSourceProp.getMybatis();
        this.checkNotBlank(prefix + "mybatis", mybatisProperties);
        this.checkNotBlank(prefix + "mybatis.base-package", mybatisProperties.getBasePackage());
    }

    private void checkNotBlank(String name, Object val) {
        if (ObjectUtils.isEmpty((Object)val)) {
            throw new IllegalArgumentException("\u591a\u6570\u636e\u6e90\u914d\u7f6e: '" + name + "' \u5fc5\u586b");
        }
    }

    private MultiDataSourceProps buildMultiDataSourceProps(Environment environment) {
        BindResult result = Binder.get((Environment)environment).bind("spring", MultiDataSourceProps.class);
        MultiDataSourceProps multiDataSourceProps = (MultiDataSourceProps)result.get();
        int mainCount = 0;
        Set<Map.Entry<String, DataSourceProp>> entries = multiDataSourceProps.getMultiDatasource().entrySet();
        for (Map.Entry<String, DataSourceProp> entry : entries) {
            DataSourceProp prop = entry.getValue();
            Boolean main = prop.getMain();
            if (main.booleanValue()) {
                ++mainCount;
            }
            if (mainCount <= 1) continue;
            String dsAlias = entry.getKey();
            throw new RuntimeException("\u53ea\u80fd\u6307\u5b9a\u4e00\u4e2a\u4e3b\u6570\u636e\u6e90, \u53c2\u8003\u8bbe\u7f6e 'spring.multi-datasource." + dsAlias + ".main=false'");
        }
        if (mainCount == 0) {
            throw new RuntimeException("\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u4e3b\u6570\u636e\u6e90\uff0c'spring.multi-datasource.xx.main=true'");
        }
        return multiDataSourceProps;
    }
}

