/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure.multi;

import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.MyBatisComponent;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class MultiDataSourceContext {
    private static final Map<String, MyBatisComponent> COMPONENT_HASH_MAP = new HashMap<String, MyBatisComponent>();
    private static final Map<String, MyBatisComponent> DATA_SOURCE_KEY_MAP = new HashMap<String, MyBatisComponent>();

    public static void setMyBatisComponent(String dsAlias, MyBatisComponent myBatisComponent) {
        COMPONENT_HASH_MAP.put(dsAlias, myBatisComponent);
        DATA_SOURCE_KEY_MAP.put(myBatisComponent.getDataSource().toString(), myBatisComponent);
    }

    public static MyBatisComponent get(DataSource dataSource) {
        return DATA_SOURCE_KEY_MAP.get(dataSource.toString());
    }

    public static MyBatisComponent get(String dsAlias) {
        return COMPONENT_HASH_MAP.get(dsAlias);
    }
}

