/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure.multi;

import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceProp;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DatasourcePropContext;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="spring")
public class MultiDataSourceProps {
    public static final String SPRING_MULTI_DATASOURCE = "spring.multi-datasource";
    private Map<String, DataSourceProp> multiDatasource;

    public Map<String, DataSourceProp> getMultiDatasource() {
        return this.multiDatasource;
    }

    public DatasourcePropContext getMainDataSourceProp() {
        Set<Map.Entry<String, DataSourceProp>> entrySet = this.multiDatasource.entrySet();
        if (entrySet.size() == 1) {
            Map.Entry<String, DataSourceProp> entry2 = entrySet.iterator().next();
            return DatasourcePropContext.ofMain(entry2);
        }
        return entrySet.stream().filter(entry -> ((DataSourceProp)entry.getValue()).getMain()).findFirst().map(DatasourcePropContext::ofMain).orElseGet(() -> DatasourcePropContext.ofMain((Map.Entry)entrySet.iterator().next()));
    }

    public List<DatasourcePropContext> getNotMainDataSourceProp() {
        if (this.multiDatasource.size() == 1) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, DataSourceProp> retMap = new LinkedHashMap<String, DataSourceProp>(this.multiDatasource);
        DatasourcePropContext mainDataSourceProp = this.getMainDataSourceProp();
        return retMap.entrySet().stream().filter(entry -> !Objects.equals(mainDataSourceProp.getDsAlias(), entry.getKey())).map(DatasourcePropContext::ofNotMain).collect(Collectors.toList());
    }

    public void setMultiDatasource(Map<String, DataSourceProp> multiDatasource) {
        this.multiDatasource = multiDatasource;
    }
}

