/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure.multi;

import java.util.Arrays;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class MultiDatasourceCondition
implements ConfigurationCondition {
    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        Environment environment = conditionContext.getEnvironment();
        if (environment instanceof ConfigurableEnvironment) {
            StandardEnvironment standardEnvironment = (StandardEnvironment)environment;
            MutablePropertySources sources = standardEnvironment.getPropertySources();
            return sources.stream().filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).anyMatch(data -> data.startsWith("spring.multi-datasource"));
        }
        return false;
    }
}

