/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.spring.boot.autoconfigure.multi;

import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.ConditionalOnMultiDatasource;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DataSourceProp;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.DatasourcePropContext;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.MapperScannerRegistrar;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.MultiDataSourceContext;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.MultiDataSourceProps;
import com.gitee.fastmybatis.spring.boot.autoconfigure.multi.MyBatisComponent;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={MultiDataSourceProps.class})
@ConditionalOnMultiDatasource
public class MultiMybatisAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MultiMybatisAutoConfiguration.class);
    private final ConfigurableListableBeanFactory configurableListableBeanFactory;
    private final MultiDataSourceProps multiDataSourceProps;

    public MultiMybatisAutoConfiguration(MultiDataSourceProps multiDataSourceProps, ConfigurableListableBeanFactory configurableListableBeanFactory) {
        this.multiDataSourceProps = multiDataSourceProps;
        this.configurableListableBeanFactory = configurableListableBeanFactory;
    }

    @Primary
    @Bean
    public DataSource dataSource() {
        DatasourcePropContext datasourcePropContext = this.multiDataSourceProps.getMainDataSourceProp();
        MyBatisComponent myBatisComponent = MultiDataSourceContext.get(datasourcePropContext.getDsAlias());
        return myBatisComponent.getDataSource();
    }

    @Primary
    @Bean
    @ConditionalOnMissingBean(value={DataSourceTransactionManager.class})
    public DataSourceTransactionManager transactionManager(DataSource dataSource, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        MyBatisComponent myBatisComponent = MultiDataSourceContext.get(dataSource);
        DataSourceTransactionManager transactionManager = myBatisComponent.getTransactionManager();
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)transactionManager));
        return transactionManager;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={TransactionTemplate.class})
    public TransactionTemplate transactionTemplate(DataSource dataSource) {
        MyBatisComponent myBatisComponent = MultiDataSourceContext.get(dataSource);
        return myBatisComponent.getTransactionTemplate();
    }

    @Primary
    @Bean
    public SqlSessionFactory sqlSessionFactory(@Autowired DataSource dataSource) throws Exception {
        MyBatisComponent myBatisComponent = MultiDataSourceContext.get(dataSource);
        this.initOtherSqlSessionFactory();
        return myBatisComponent.getSqlSessionFactory();
    }

    @Primary
    @Bean
    public SqlSessionTemplate sqlSessionTemplate(@Autowired DataSource dataSource) {
        MyBatisComponent myBatisComponent = MultiDataSourceContext.get(dataSource);
        DatasourcePropContext datasourcePropContext = myBatisComponent.getDatasourcePropContext();
        return this.buildSqlSessionTemplate(datasourcePropContext, myBatisComponent.getSqlSessionFactory());
    }

    private SqlSessionTemplate buildSqlSessionTemplate(DatasourcePropContext datasourcePropContext, SqlSessionFactory sqlSessionFactory) {
        DataSourceProp dataSourceProp = datasourcePropContext.getDataSourceProp();
        ExecutorType executorType = dataSourceProp.getMybatis().getExecutorType();
        if (executorType != null) {
            return new SqlSessionTemplate(sqlSessionFactory, executorType);
        }
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    private void initOtherSqlSessionFactory() throws Exception {
        List<DatasourcePropContext> notMainDataSourceProp = this.multiDataSourceProps.getNotMainDataSourceProp();
        if (notMainDataSourceProp == null || notMainDataSourceProp.isEmpty()) {
            return;
        }
        for (DatasourcePropContext context : notMainDataSourceProp) {
            String dsAlias = context.getDsAlias();
            DataSourceProp dataSourceProp = context.getDataSourceProp();
            String name = dataSourceProp.getName();
            if (name == null || name.isEmpty()) {
                dataSourceProp.setName(dsAlias);
            }
            MyBatisComponent myBatisComponent = MultiDataSourceContext.get(dsAlias);
            this.registerTransactionManager(context, myBatisComponent);
            this.registerSqlSessionTemplate(context, myBatisComponent);
        }
    }

    private void registerTransactionManager(DatasourcePropContext context, MyBatisComponent myBatisComponent) {
        DataSourceTransactionManager transactionManager = myBatisComponent.getTransactionManager();
        String dsAlias = context.getDsAlias();
        String transactionManagerBeanName = "transactionManager" + dsAlias;
        this.registerBeanDefinition(transactionManagerBeanName, transactionManager);
    }

    private void registerSqlSessionTemplate(DatasourcePropContext datasourcePropContext, MyBatisComponent myBatisComponent) {
        SqlSessionFactory sqlSessionFactory = myBatisComponent.getSqlSessionFactory();
        SqlSessionTemplate sqlSessionTemplate = this.buildSqlSessionTemplate(datasourcePropContext, sqlSessionFactory);
        String beanName = "sqlSessionTemplate" + datasourcePropContext.getDsAlias();
        this.registerBeanDefinition(beanName, sqlSessionTemplate);
    }

    private void registerBeanDefinition(String beanName, Object object) {
        this.configurableListableBeanFactory.registerSingleton(beanName, object);
    }

    @Configuration
    @Import(value={MapperScannerRegistrar.class})
    @ConditionalOnMissingBean(value={MapperFactoryBean.class})
    @ConditionalOnMultiDatasource
    @EnableConfigurationProperties(value={MultiDataSourceProps.class})
    public static class MapperScannerRegistrarNotFoundConfiguration
    implements InitializingBean {
        public void afterPropertiesSet() {
            logger.debug("No {} found.", (Object)MapperFactoryBean.class.getName());
        }
    }
}

