/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.spi.impl;

import com.gitee.fastmybatis.core.ext.MapperRunner;
import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.ext.spi.MapperBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringContextMapperBuilder
implements MapperBuilder {
    private static final Logger log = LoggerFactory.getLogger(SpringContextMapperBuilder.class);
    private static final Map<Class<?>, MapperRunner<?>> CACHE = new ConcurrentHashMap(64);

    public <T> MapperRunner<T> getMapperRunner(Class<T> mapperClass, Object applicationContext) {
        return CACHE.computeIfAbsent(mapperClass, k -> {
            Object mapper;
            ApplicationContext ctx = (ApplicationContext)applicationContext;
            try {
                mapper = ctx.getBean(mapperClass);
            }
            catch (Exception e) {
                String simpleName = mapperClass.getSimpleName();
                String beanName = FieldUtil.lowerFirstLetter((String)simpleName);
                log.debug("ApplicationContext.getBean(" + simpleName + ".class) can not found instance, try to find use ctx.getBean(\"" + beanName + "\")");
                mapper = ctx.getBean(beanName);
            }
            return new MapperRunner(mapper, null);
        });
    }
}

