/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.transaction;

import com.gitee.fastmybatis.core.ext.util.MybatisUtil;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public interface DbSupport {
    public String getDataSourceAlias();

    default public <T> T doTransaction(TransactionCallback<T> action) throws TransactionException {
        return MybatisUtil.doTransaction(this.getDataSourceAlias(), action);
    }

    default public void doTransactionNoResult(TransactionCallback<?> action) throws TransactionException {
        this.doTransaction(action);
    }

    default public TransactionTemplate getTransactionTemplate() {
        return MybatisUtil.getTransactionTemplate(this.getDataSourceAlias());
    }

    default public SqlSessionFactory getSqlSessionFactory() {
        return MybatisUtil.getSqlSessionFactory(this.getDataSourceAlias());
    }
}

