/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.transaction;

import com.gitee.fastmybatis.core.ext.transaction.AliasTransactionTemplate;
import java.util.HashMap;
import java.util.Map;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionTemplateManager {
    private static final Map<String, AliasTransactionTemplate> TRANSACTION_TEMPLATE_MAP = new HashMap<String, AliasTransactionTemplate>();
    private static final String MAIN_ALIAS = "_ds_main_";

    private TransactionTemplateManager() {
    }

    public static void addTransactionTemplate(AliasTransactionTemplate transactionTemplate) {
        TRANSACTION_TEMPLATE_MAP.put(transactionTemplate.getDbAlias(), transactionTemplate);
    }

    public static void addMainTransactionManager(PlatformTransactionManager transactionManager) {
        AliasTransactionTemplate transactionTemplate = new AliasTransactionTemplate(MAIN_ALIAS, transactionManager);
        TransactionTemplateManager.addTransactionTemplate(transactionTemplate);
    }

    public static TransactionTemplate getTransactionTemplate(String dbAlias) {
        AliasTransactionTemplate aliasTransactionTemplate = TRANSACTION_TEMPLATE_MAP.get(dbAlias);
        if (aliasTransactionTemplate == null) {
            return TRANSACTION_TEMPLATE_MAP.get(MAIN_ALIAS);
        }
        return aliasTransactionTemplate;
    }
}

