/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.util;

import com.gitee.fastmybatis.core.MybatisContext;
import com.gitee.fastmybatis.core.ext.transaction.TransactionTemplateManager;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class MybatisUtil {
    public static SqlSessionFactory getSqlSessionFactory() {
        return MybatisContext.getMainSqlSessionFactory();
    }

    public static SqlSessionFactory getSqlSessionFactory(Class<?> mapperClass) {
        return MybatisContext.getSqlSessionFactoryByMapperClass(mapperClass);
    }

    public static SqlSessionFactory getSqlSessionFactory(String dataSourceAlias) {
        return MybatisContext.getSqlSessionFactoryByDataSourceAlias((String)dataSourceAlias);
    }

    public static TransactionTemplate getTransactionTemplate() {
        return TransactionTemplateManager.getTransactionTemplate("_ds_main_");
    }

    public static TransactionTemplate getTransactionTemplate(String dataSourceAlias) {
        return TransactionTemplateManager.getTransactionTemplate(dataSourceAlias);
    }

    public static <T> T doTransaction(TransactionCallback<T> action) throws TransactionException {
        return MybatisUtil.doTransaction(MybatisUtil.getTransactionTemplate(), action);
    }

    private static <T> T doTransaction(TransactionTemplate transactionTemplate, TransactionCallback<T> action) throws TransactionException {
        Objects.requireNonNull(transactionTemplate, "\u627e\u4e0d\u5230transactionTemplate");
        return (T)transactionTemplate.execute(action);
    }

    public static void doTransactionNoResult(Consumer<TransactionStatus> action) throws TransactionException {
        MybatisUtil.doTransaction(transactionStatus -> {
            action.accept(transactionStatus);
            return null;
        });
    }

    public static <T> T doTransaction(String dbAlias, TransactionCallback<T> action) throws TransactionException {
        TransactionTemplate transactionTemplate = MybatisUtil.getTransactionTemplate(dbAlias);
        return MybatisUtil.doTransaction(transactionTemplate, action);
    }

    public static void doTransactionNoResult(String dbAlias, Consumer<TransactionStatus> action) throws TransactionException {
        MybatisUtil.doTransaction(dbAlias, transactionStatus -> {
            action.accept(transactionStatus);
            return null;
        });
    }
}

