/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html;

import com.deepoove.poi.render.RenderContext;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ooxml.util.POIXMLUnits;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.SVGRelation;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.ElementRendererProvider;
import org.ddr.poi.html.HtmlConstants;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.CSSLengthUnit;
import org.ddr.poi.html.util.CSSStyleUtils;
import org.ddr.poi.html.util.Colors;
import org.ddr.poi.html.util.InlineStyle;
import org.ddr.poi.html.util.NamedFontSize;
import org.ddr.poi.html.util.NumberingContext;
import org.ddr.poi.html.util.RenderUtils;
import org.ddr.poi.html.util.WhiteSpaceRule;
import org.ddr.poi.html.util.XWPFParagraphRuns;
import org.ddr.poi.util.XmlUtils;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectFrameLocking;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualGraphicFrameProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOfficeArtExtension;
import org.openxmlformats.schemas.drawingml.x2006.main.CTOfficeArtExtensionList;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTPosH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTPosV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STAlignH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STAlignV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromV;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTwipsMeasure;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSignedTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STThemeColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlRenderContext
extends RenderContext<String> {
    private static final Logger log = LoggerFactory.getLogger(HtmlRenderContext.class);
    private static final QName R_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "r");
    private static final QName HYPERLINK_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "hyperlink");
    private static final CSSLength DEFAULT_FONT_SIZE = new CSSLength(12.0, CSSLengthUnit.PT);
    private static final String DEFAULT_HYPERLINK_COLOR = "0563C1";
    private final ElementRendererProvider rendererProvider;
    private LinkedList<IBody> ancestors = new LinkedList();
    private LinkedList<InlineStyle> inlineStyles = new LinkedList();
    private LinkedList<Integer> fontSizesInHalfPoints = new LinkedList();
    private final NumberingContext numberingContext;
    private final CSSLength defaultFontSize;
    private final CSSLength pageWidth;
    private final CSSLength pageHeight;
    private final CSSLength marginTop;
    private final CSSLength marginRight;
    private final CSSLength marginBottom;
    private final CSSLength marginLeft;
    private final int availablePageWidth;
    private final int availablePageHeight;
    private String placeholderStyleId;
    private XWPFRun currentRun;
    private String globalFont;
    private BigInteger globalFontSize;
    private boolean showDefaultTableBorderInTableCell;
    private int blockLevel;
    private XmlCursor globalCursor;
    private XWPFParagraph dedupeParagraph;
    private TextWrapper previousText;

    public HtmlRenderContext(RenderContext<String> context, ElementRendererProvider rendererProvider) {
        super(context.getEleTemplate(), context.getData(), context.getTemplate());
        this.rendererProvider = rendererProvider;
        this.globalCursor = this.getRun().getCTR().newCursor();
        this.numberingContext = new NumberingContext((XWPFDocument)this.getXWPFDocument());
        long w = 7560310L;
        long h = 10692130L;
        long top = 914400L;
        long right = 914400L;
        long bottom = 914400L;
        long left = 914400L;
        CTSectPr sectPr = this.getXWPFDocument().getDocument().getBody().getSectPr();
        if (sectPr != null) {
            CTPageMar pgMar;
            CTPageSz pgSz = sectPr.getPgSz();
            if (pgSz != null) {
                w = POIXMLUnits.parseLength((STTwipsMeasure)pgSz.xgetW());
                h = POIXMLUnits.parseLength((STTwipsMeasure)pgSz.xgetH());
            }
            if ((pgMar = sectPr.getPgMar()) != null) {
                top = POIXMLUnits.parseLength((STSignedTwipsMeasure)pgMar.xgetTop());
                right = POIXMLUnits.parseLength((STTwipsMeasure)pgMar.xgetRight());
                bottom = POIXMLUnits.parseLength((STSignedTwipsMeasure)pgMar.xgetBottom());
                left = POIXMLUnits.parseLength((STTwipsMeasure)pgMar.xgetLeft());
            }
        }
        this.pageWidth = new CSSLength(w, CSSLengthUnit.EMU);
        this.pageHeight = new CSSLength(h, CSSLengthUnit.EMU);
        this.marginTop = new CSSLength(top, CSSLengthUnit.EMU);
        this.marginRight = new CSSLength(right, CSSLengthUnit.EMU);
        this.marginBottom = new CSSLength(bottom, CSSLengthUnit.EMU);
        this.marginLeft = new CSSLength(left, CSSLengthUnit.EMU);
        this.availablePageWidth = (int)(w - left - right);
        this.availablePageHeight = (int)(h - top - bottom);
        Double fontSize = this.getXWPFDocument().getStyles().getDefaultRunStyle().getFontSizeAsDouble();
        this.defaultFontSize = fontSize != null ? new CSSLength(fontSize, CSSLengthUnit.PT) : DEFAULT_FONT_SIZE;
        this.extractPlaceholderStyle();
    }

    private void extractPlaceholderStyle() {
        XWPFRun run = this.getRun();
        IRunBody runParent = run.getParent();
        if (runParent instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)runParent;
            String styleId = paragraph.getStyleID();
            boolean existsRPr = run.getCTR().isSetRPr();
            if (styleId == null && !existsRPr) {
                return;
            }
            if (styleId != null && !existsRPr) {
                this.placeholderStyleId = styleId;
                return;
            }
            XWPFStyles styles = this.getXWPFDocument().getStyles();
            CTStyle newCTStyle = (CTStyle)CTStyle.Factory.newInstance();
            newCTStyle.setCustomStyle((Object)true);
            newCTStyle.setType(STStyleType.PARAGRAPH);
            newCTStyle.addNewHidden();
            newCTStyle.setRPr(run.getCTR().getRPr());
            XmlUtils.removeNamespaces((XmlObject)newCTStyle.getRPr());
            String newStyleId = styleId + styles.getNumberOfStyles();
            newCTStyle.setStyleId(newStyleId);
            newCTStyle.addNewName().setVal(newStyleId);
            this.placeholderStyleId = newStyleId;
            if (styleId != null) {
                newCTStyle.addNewBasedOn().setVal(styleId);
            }
            XWPFStyle newStyle = new XWPFStyle(newCTStyle, styles);
            styles.addStyle(newStyle);
            paragraph.setStyle(newStyleId);
        }
    }

    public IBody getContainer() {
        IBody container = this.ancestors.peek();
        return container == null ? super.getContainer() : container;
    }

    public void pushContainer(IBody body) {
        this.ancestors.push(body);
    }

    public void popContainer() {
        this.ancestors.pop();
    }

    public XWPFParagraph getClosestParagraph() {
        if (this.globalCursor.getObject() == this.getRun().getCTR()) {
            return (XWPFParagraph)this.getRun().getParent();
        }
        this.globalCursor.push();
        XWPFParagraph paragraph = null;
        if (this.globalCursor.toPrevSibling()) {
            XmlObject object = this.globalCursor.getObject();
            if (object instanceof CTP) {
                paragraph = this.getContainer().getParagraph((CTP)object);
            } else {
                this.globalCursor.pop();
                this.globalCursor.push();
                paragraph = this.newParagraph(null, this.globalCursor);
                RenderUtils.paragraphStyle(this, paragraph, CSSStyleUtils.EMPTY_STYLE);
            }
        }
        this.globalCursor.pop();
        if (paragraph != null) {
            return paragraph;
        }
        throw new IllegalStateException("No paragraph in stack");
    }

    public void startHyperlink(String uri) {
        try {
            URI.create(uri);
        }
        catch (Exception e) {
            log.warn("Illegal href", (Throwable)e);
            uri = "#";
        }
        if (this.isBlocked()) {
            XWPFParagraph paragraph = this.getClosestParagraph();
            this.currentRun = paragraph.createHyperlinkRun(uri);
            if (this.dedupeParagraph == paragraph) {
                this.unmarkDedupe();
            }
        } else {
            String rId = this.getRun().getParent().getPart().getPackagePart().addExternalRelationship(uri, XWPFRelation.HYPERLINK.getRelation()).getId();
            XmlCursor xmlCursor = this.getRun().getCTR().newCursor();
            xmlCursor.insertElement(HYPERLINK_QNAME);
            xmlCursor.toPrevSibling();
            CTHyperlink ctHyperlink = (CTHyperlink)xmlCursor.getObject();
            xmlCursor.dispose();
            ctHyperlink.setId(rId);
            ctHyperlink.addNewR();
            this.currentRun = new XWPFHyperlinkRun(ctHyperlink, ctHyperlink.getRArray(0), this.getRun().getParent());
        }
    }

    public void endHyperlink() {
        this.currentRun = null;
    }

    public XWPFParagraph newParagraph(IBody container, XmlCursor cursor) {
        if (container == null) {
            container = this.getContainer();
        }
        XWPFParagraph xwpfParagraph = container.insertNewParagraph(cursor);
        if (this.placeholderStyleId != null) {
            xwpfParagraph.setStyle(this.placeholderStyleId);
        }
        this.markDedupe(xwpfParagraph);
        this.previousText = null;
        return xwpfParagraph;
    }

    public CTR newRun() {
        if (this.currentRun instanceof XWPFHyperlinkRun) {
            XmlCursor xmlCursor = this.currentRun.getCTR().newCursor();
            CTR ctr = xmlCursor.toFirstChild() ? ((XWPFHyperlinkRun)this.currentRun).getCTHyperlink().addNewR() : this.currentRun.getCTR();
            xmlCursor.dispose();
            this.initHyperlinkStyle(ctr);
            return ctr;
        }
        if (this.isBlocked()) {
            XWPFParagraph paragraph = this.getClosestParagraph();
            this.currentRun = paragraph.createRun();
            if (this.dedupeParagraph == paragraph) {
                this.unmarkDedupe();
            }
        } else {
            XmlCursor xmlCursor = this.getRun().getCTR().newCursor();
            xmlCursor.insertElement(R_QNAME);
            xmlCursor.toPrevSibling();
            CTR ctr = (CTR)xmlCursor.getObject();
            xmlCursor.dispose();
            this.currentRun = new XWPFRun(ctr, this.getRun().getParent());
        }
        return this.currentRun.getCTR();
    }

    private void initHyperlinkStyle(CTR ctr) {
        CTRPr rPr = RenderUtils.getRPr(ctr);
        CTColor ctColor = rPr.addNewColor();
        ctColor.setVal((Object)DEFAULT_HYPERLINK_COLOR);
        ctColor.setThemeColor(STThemeColor.HYPERLINK);
        rPr.addNewU().setVal(STUnderline.SINGLE);
    }

    public XWPFTable getClosestTable() {
        XmlObject object;
        this.globalCursor.push();
        XWPFTable table = null;
        if (this.globalCursor.toPrevSibling() && (object = this.globalCursor.getObject()) instanceof CTTbl) {
            table = this.getContainer().getTable((CTTbl)object);
        }
        this.globalCursor.pop();
        if (table != null) {
            return table;
        }
        throw new IllegalStateException("No table in stack");
    }

    public void pushInlineStyle(CSSStyleDeclarationImpl inlineStyle, boolean block) {
        String newFontSize = inlineStyle.getFontSize();
        int fontSize = Integer.MIN_VALUE;
        if (StringUtils.isNotBlank((CharSequence)newFontSize)) {
            NamedFontSize namedFontSize = NamedFontSize.of(newFontSize);
            if (namedFontSize != null) {
                fontSize = namedFontSize.getSize().toHalfPoints();
            } else if ("smaller".equalsIgnoreCase(newFontSize)) {
                int inheritedFontSize = this.getInheritedFontSizeInHalfPoints();
                fontSize = RenderUtils.smallerFontSizeInHalfPoints(inheritedFontSize);
            } else if ("larger".equalsIgnoreCase(newFontSize)) {
                int inheritedFontSize = this.getInheritedFontSizeInHalfPoints();
                fontSize = RenderUtils.largerFontSizeInHalfPoints(inheritedFontSize);
            } else {
                CSSLength cssLength = CSSLength.of(newFontSize);
                if (cssLength.isValid()) {
                    if (cssLength.getUnit() == CSSLengthUnit.PERCENT) {
                        fontSize = (int)Math.rint((double)this.getInheritedFontSizeInHalfPoints() * cssLength.getValue() * cssLength.getUnit().absoluteFactor());
                    } else {
                        int emu = this.lengthToEMU(cssLength);
                        fontSize = emu * 2 / 12700;
                    }
                }
            }
        }
        this.fontSizesInHalfPoints.push(fontSize);
        String textDecorationLine = inlineStyle.getPropertyValue("text-decoration-line");
        if (StringUtils.isNotBlank((CharSequence)textDecorationLine) && !"none".equals(textDecorationLine)) {
            String[] values;
            HashSet<String> remainValues = new HashSet<String>(HtmlConstants.TEXT_DECORATION_LINES);
            for (String value : values = StringUtils.split((String)textDecorationLine, (char)' ')) {
                remainValues.remove(value);
            }
            if (!remainValues.isEmpty()) {
                InlineStyle inheritedStyle;
                String s;
                StringBuilder lines = new StringBuilder(textDecorationLine);
                Iterator iterator = this.inlineStyles.iterator();
                while (iterator.hasNext() && !"none".equals(s = (inheritedStyle = (InlineStyle)iterator.next()).getDeclaration().getPropertyValue("text-decoration-line"))) {
                    if (!remainValues.contains(s)) continue;
                    lines.append(' ').append(s);
                    remainValues.remove(s);
                    if (!remainValues.isEmpty()) continue;
                    break;
                }
                if (lines.length() > textDecorationLine.length()) {
                    inlineStyle.setProperty("text-decoration-line", lines.toString(), null);
                }
            }
        }
        this.inlineStyles.push(new InlineStyle(inlineStyle, block));
    }

    public void popInlineStyle() {
        this.fontSizesInHalfPoints.pop();
        this.inlineStyles.pop();
    }

    public CSSStyleDeclarationImpl currentElementStyle() {
        InlineStyle inlineStyle = this.inlineStyles.peek();
        return inlineStyle == null ? CSSStyleUtils.EMPTY_STYLE : inlineStyle.getDeclaration();
    }

    public String getPropertyValue(String property) {
        return this.getPropertyValue(property, false);
    }

    public String getPropertyValue(String property, boolean inlineOnly) {
        return this.getPropertyValue(property, false, inlineOnly);
    }

    public String getPropertyValue(String property, boolean caseSensitive, boolean inlineOnly) {
        for (InlineStyle inlineStyle : this.inlineStyles) {
            if (inlineOnly && inlineStyle.isBlock()) break;
            String propertyValue = inlineStyle.getDeclaration().getPropertyValue(property);
            if (!StringUtils.isNotBlank((CharSequence)propertyValue)) continue;
            return caseSensitive ? propertyValue : propertyValue.toLowerCase();
        }
        return "";
    }

    public CSSLength getDefaultFontSize() {
        return this.defaultFontSize;
    }

    public int getInheritedFontSizeInHalfPoints() {
        for (Integer fontSize : this.fontSizesInHalfPoints) {
            if (fontSize <= 0) continue;
            return fontSize;
        }
        return this.defaultFontSize.toHalfPoints();
    }

    public int getAvailableWidthInEMU() {
        IBody container = this.getContainer();
        if (container.getPartType() == BodyType.DOCUMENT) {
            return this.availablePageWidth;
        }
        return RenderUtils.getAvailableWidthInEMU(container);
    }

    public int computeLengthInEMU(String length, String maxLength, int naturalEMU, int parentEMU) {
        CSSLength cssLength;
        int emu = naturalEMU;
        if (length.length() > 0 && (cssLength = CSSLength.of(length)).isValid()) {
            emu = this.computeLengthInEMU(cssLength, naturalEMU, parentEMU);
        }
        if (maxLength.length() > 0 && (cssLength = CSSLength.of(maxLength)).isValid()) {
            int maxEMU = this.computeLengthInEMU(cssLength, naturalEMU, parentEMU);
            emu = Math.min(maxEMU, emu);
        }
        return Math.min(emu, parentEMU);
    }

    public int computeLengthInEMU(CSSLength cssLength, int naturalEMU, int parentEMU) {
        int length = cssLength.getUnit() == CSSLengthUnit.PERCENT ? (parentEMU != Integer.MAX_VALUE ? (int)((double)parentEMU * cssLength.getValue() * cssLength.getUnit().absoluteFactor()) : naturalEMU) : this.lengthToEMU(cssLength);
        return length;
    }

    public void renderText(String text) {
        int c;
        String whiteSpace = this.getPropertyValue("white-space");
        WhiteSpaceRule rule = WhiteSpaceRule.of(whiteSpace, WhiteSpaceRule.NORMAL);
        StringBuilder sb = StringUtil.borrowBuilder();
        boolean mergeWhitespace = false;
        int len = text.length();
        if (!rule.isKeepTrailingSpace()) {
            boolean reachedLastNonWhite = false;
            for (int i = len - 1; i >= 0; i -= Character.charCount(c)) {
                c = text.codePointAt(i);
                switch (c) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: 
                    case 173: 
                    case 8203: 
                    case 8204: 
                    case 8205: 
                    case 8206: 
                    case 8207: 
                    case 8288: 
                    case 8289: 
                    case 8290: 
                    case 8291: {
                        len = i;
                        break;
                    }
                    default: {
                        if (Character.getType(c) == 16) {
                            len = i;
                            break;
                        }
                        reachedLastNonWhite = true;
                    }
                }
                if (reachedLastNonWhite) break;
            }
        }
        if (len == 0) {
            return;
        }
        boolean endTrimmed = len < text.length();
        CTR ctr = this.newRun();
        block12: for (int i = 0; i < len; i += Character.charCount(c)) {
            c = text.codePointAt(i);
            switch (c) {
                case 13: {
                    if (i + 1 < len && text.codePointAt(i + 1) == 10) continue block12;
                    if (rule.isKeepLineBreak()) {
                        this.addText(ctr, sb, false);
                        ctr.addNewCr();
                        continue block12;
                    }
                    mergeWhitespace = true;
                    continue block12;
                }
                case 10: {
                    if (rule.isKeepLineBreak()) {
                        this.addText(ctr, sb, false);
                        ctr.addNewBr();
                        continue block12;
                    }
                    mergeWhitespace = true;
                    continue block12;
                }
                case 32: {
                    if (rule.isKeepSpaceAndTab()) {
                        sb.appendCodePoint(c);
                        continue block12;
                    }
                    mergeWhitespace = true;
                    continue block12;
                }
                case 9: {
                    if (rule.isKeepSpaceAndTab()) {
                        this.addText(ctr, sb, false);
                        ctr.addNewTab();
                        continue block12;
                    }
                    mergeWhitespace = true;
                    continue block12;
                }
                case 160: 
                case 8192: 
                case 8193: 
                case 8194: 
                case 8195: 
                case 8196: 
                case 8197: 
                case 8199: 
                case 8200: 
                case 8201: 
                case 8202: 
                case 8239: 
                case 8287: {
                    if (mergeWhitespace) {
                        sb.append(' ');
                        mergeWhitespace = false;
                    }
                    sb.append(' ');
                    continue block12;
                }
                case 173: 
                case 8203: 
                case 8204: 
                case 8205: 
                case 8206: 
                case 8207: 
                case 8288: 
                case 8289: 
                case 8290: 
                case 8291: {
                    continue block12;
                }
                default: {
                    if (Character.getType(c) == 16) continue block12;
                    if (mergeWhitespace) {
                        sb.append(' ');
                        mergeWhitespace = false;
                    }
                    sb.appendCodePoint(c);
                    if (this.previousText == null || !this.previousText.isEndTrimmed()) continue block12;
                    CTText previous = this.previousText.getText();
                    previous.setStringValue(previous.getStringValue() + ' ');
                    previous.setSpace(SpaceAttribute.Space.PRESERVE);
                    this.previousText = null;
                }
            }
        }
        this.addText(ctr, sb, endTrimmed);
        StringUtil.releaseBuilder((StringBuilder)sb);
        this.applyTextStyle(ctr);
        if (!(this.currentRun instanceof XWPFHyperlinkRun)) {
            this.currentRun = null;
        }
    }

    private void addText(CTR ctr, StringBuilder sb, boolean endTrimmed) {
        if (sb.length() > 0) {
            CTText ctText = ctr.addNewT();
            String text = sb.toString();
            ctText.setStringValue(text);
            if (text.charAt(0) == ' ' || text.charAt(sb.length() - 1) == ' ') {
                ctText.setSpace(SpaceAttribute.Space.PRESERVE);
            }
            sb.delete(0, sb.length());
            this.previousText = new TextWrapper(ctText, endTrimmed);
        }
    }

    private void applyTextStyle(CTR ctr) {
        String visibility;
        String hex;
        String textDecoration;
        String caps;
        String color;
        String fontFamily;
        CTRPr rPr = RenderUtils.getRPr(ctr);
        String string = fontFamily = StringUtils.isBlank((CharSequence)this.globalFont) ? this.getPropertyValue("font-family") : this.globalFont;
        if (StringUtils.isNotBlank((CharSequence)fontFamily)) {
            CTFonts ctFonts = rPr.addNewRFonts();
            ctFonts.setAscii(fontFamily);
            ctFonts.setHAnsi(fontFamily);
            ctFonts.setCs(fontFamily);
            ctFonts.setEastAsia(fontFamily);
        }
        if (this.globalFontSize == null) {
            String fontSize = this.getPropertyValue("font-size");
            if (StringUtils.isNotBlank((CharSequence)fontSize)) {
                int sz = this.getInheritedFontSizeInHalfPoints();
                rPr.addNewSz().setVal((Object)BigInteger.valueOf(sz));
            }
        } else {
            rPr.addNewSz().setVal((Object)this.globalFontSize);
        }
        String fontWeight = this.getPropertyValue("font-weight");
        if (fontWeight.contains("bold")) {
            rPr.addNewB();
        } else if (NumberUtils.isParsable((String)fontWeight) && Float.parseFloat(fontWeight) > 500.0f) {
            rPr.addNewB();
        }
        String fontStyle = this.getPropertyValue("font-style");
        if ("italic".equals(fontStyle) || "oblique".equals(fontStyle)) {
            rPr.addNewI();
        }
        if (StringUtils.isNotBlank((CharSequence)(color = this.getPropertyValue("color")))) {
            String hex2 = Colors.fromStyle(color);
            RenderUtils.getColor(rPr).setVal((Object)hex2);
        }
        if ("small-caps".equals(caps = this.getPropertyValue("font-variant-caps"))) {
            rPr.addNewSmallCaps();
        }
        if ("none".equals(textDecoration = this.getPropertyValue("text-decoration-line"))) {
            RenderUtils.getUnderline(rPr).setVal(STUnderline.NONE);
        } else {
            if (StringUtils.contains((CharSequence)textDecoration, (CharSequence)"line-through")) {
                rPr.addNewStrike();
            }
            if (StringUtils.contains((CharSequence)textDecoration, (CharSequence)"underline")) {
                CTUnderline ctUnderline = RenderUtils.getUnderline(rPr);
                String textDecorationStyle = this.getPropertyValue("text-decoration-style");
                ctUnderline.setVal(RenderUtils.underline(textDecorationStyle));
                String textDecorationColor = this.getPropertyValue("text-decoration-color");
                if (StringUtils.isNotBlank((CharSequence)textDecorationColor)) {
                    String hex3 = Colors.fromStyle(textDecorationColor);
                    ctUnderline.setColor((Object)hex3);
                }
            }
        }
        String verticalAlign = this.getPropertyValue("vertical-align");
        if ("super".equals(verticalAlign)) {
            rPr.addNewVertAlign().setVal(STVerticalAlignRun.SUPERSCRIPT);
        } else if ("sub".equals(verticalAlign)) {
            rPr.addNewVertAlign().setVal(STVerticalAlignRun.SUBSCRIPT);
        }
        String backgroundColor = this.getPropertyValue("background-color", true);
        if (StringUtils.isNotBlank((CharSequence)backgroundColor) && (hex = Colors.fromStyle(backgroundColor, null)) != null) {
            CTShd ctShd = rPr.addNewShd();
            ctShd.setFill((Object)hex);
            ctShd.setVal(STShd.CLEAR);
        }
        if ("hidden".equals(visibility = this.getPropertyValue("visibility")) || "collapse".equals(visibility)) {
            rPr.addNewVanish();
        }
    }

    public void renderPicture(InputStream pictureData, int pictureType, String filename, int width, int height, byte[] svgData) throws IOException, InvalidFormatException {
        CSSStyleDeclarationImpl styleDeclaration;
        String cssFloat;
        boolean floatLeft;
        boolean isSvg;
        CTR ctr = this.newRun();
        XWPFPicture xwpfPicture = this.currentRun.addPicture(pictureData, pictureType, filename, width, height);
        CTR r = this.currentRun.getCTR();
        boolean bl = isSvg = svgData != null;
        if (isSvg) {
            this.attachSvgData(xwpfPicture, svgData);
        }
        boolean floatRight = !(floatLeft = "left".equals(cssFloat = (styleDeclaration = this.currentElementStyle()).getPropertyValue("float"))) && "right".equals(cssFloat);
        boolean floated = floatLeft || floatRight;
        CTDrawing drawing = null;
        if (r != ctr) {
            int lastDrawingIndex = r.sizeOfDrawingArray() - 1;
            drawing = r.getDrawingArray(lastDrawingIndex);
            ctr.setDrawingArray(new CTDrawing[]{drawing});
            r.removeDrawing(lastDrawingIndex);
            drawing = ctr.getDrawingArray(0);
        } else if (isSvg || floated) {
            drawing = ctr.getDrawingArray(ctr.sizeOfDrawingArray() - 1);
        }
        if (drawing != null && drawing.sizeOfInlineArray() > 0) {
            if (floated) {
                CTAnchor ctAnchor = RenderUtils.inlineToAnchor(drawing);
                CTPosH ctPosH = ctAnchor.addNewPositionH();
                ctPosH.setRelativeFrom(STRelFromH.MARGIN);
                ctPosH.setAlign(floatRight ? STAlignH.RIGHT : STAlignH.LEFT);
                CTPosV ctPosV = ctAnchor.addNewPositionV();
                ctPosV.setRelativeFrom(STRelFromV.PARAGRAPH);
                ctPosV.setAlign(STAlignV.TOP);
                if (isSvg) {
                    CTNonVisualGraphicFrameProperties properties = ctAnchor.addNewCNvGraphicFramePr();
                    CTGraphicalObjectFrameLocking frameLocking = properties.addNewGraphicFrameLocks();
                    frameLocking.setNoChangeAspect(true);
                }
            } else if (isSvg) {
                CTInline ctInline = drawing.getInlineArray(0);
                CTNonVisualGraphicFrameProperties properties = ctInline.isSetCNvGraphicFramePr() ? ctInline.getCNvGraphicFramePr() : ctInline.addNewCNvGraphicFramePr();
                CTGraphicalObjectFrameLocking frameLocking = properties.isSetGraphicFrameLocks() ? properties.getGraphicFrameLocks() : properties.addNewGraphicFrameLocks();
                frameLocking.setNoChangeAspect(true);
            }
        }
    }

    private void attachSvgData(XWPFPicture xwpfPicture, byte[] svgData) throws InvalidFormatException {
        CTPicture ctPicture = xwpfPicture.getCTPicture();
        String svgRelId = this.getXWPFDocument().addPictureData(svgData, 1);
        CTBlip blip = ctPicture.getBlipFill().getBlip();
        if (blip != null) {
            CTOfficeArtExtensionList extList = blip.isSetExtLst() ? blip.getExtLst() : blip.addNewExtLst();
            CTOfficeArtExtension svgBitmap = extList.addNewExt();
            svgBitmap.setUri("{96DAC541-7B7A-43D3-8B79-37D633B846F1}");
            XmlCursor cur = svgBitmap.newCursor();
            cur.toEndToken();
            cur.beginElement(SVGRelation.SVG_QNAME);
            cur.insertNamespace("asvg", "http://schemas.microsoft.com/office/drawing/2016/SVG/main");
            cur.insertAttributeWithValue(SVGRelation.EMBED_TAG, svgRelId);
            cur.dispose();
        }
    }

    public int lengthToEMU(CSSLength length) {
        double emu;
        if (!length.isValid()) {
            throw new UnsupportedOperationException("Invalid CSS length");
        }
        if (!length.getUnit().isRelative()) {
            return length.toEMU();
        }
        switch (length.getUnit()) {
            case REM: {
                emu = length.unitValue() * (double)this.getDefaultFontSize().toEMU();
                break;
            }
            case EM: {
                emu = length.unitValue() * (double)this.getInheritedFontSizeInHalfPoints() * 12700.0 / 2.0;
                break;
            }
            case VW: {
                emu = length.unitValue() * (double)this.getPageWidth().toEMU();
                break;
            }
            case VH: {
                emu = length.unitValue() * (double)this.getPageHeight().toEMU();
                break;
            }
            case VMIN: {
                emu = length.unitValue() * (double)Math.min(this.getPageWidth().toEMU(), this.getPageHeight().toEMU());
                break;
            }
            case VMAX: {
                emu = length.unitValue() * (double)Math.max(this.getPageWidth().toEMU(), this.getPageHeight().toEMU());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can not convert to EMU with length: " + length);
            }
        }
        return (int)Math.rint(emu);
    }

    public NumberingContext getNumberingContext() {
        return this.numberingContext;
    }

    public CSSLength getPageWidth() {
        return this.pageWidth;
    }

    public CSSLength getPageHeight() {
        return this.pageHeight;
    }

    public CSSLength getMarginTop() {
        return this.marginTop;
    }

    public CSSLength getMarginRight() {
        return this.marginRight;
    }

    public CSSLength getMarginBottom() {
        return this.marginBottom;
    }

    public CSSLength getMarginLeft() {
        return this.marginLeft;
    }

    public int getAvailablePageWidth() {
        return this.availablePageWidth;
    }

    public int getAvailablePageHeight() {
        return this.availablePageHeight;
    }

    public XWPFRun getCurrentRun() {
        return this.currentRun;
    }

    public String getGlobalFont() {
        return this.globalFont;
    }

    public BigInteger getGlobalFontSize() {
        return this.globalFontSize;
    }

    public boolean isShowDefaultTableBorderInTableCell() {
        return this.showDefaultTableBorderInTableCell;
    }

    public void setShowDefaultTableBorderInTableCell(boolean showDefaultTableBorderInTableCell) {
        this.showDefaultTableBorderInTableCell = showDefaultTableBorderInTableCell;
    }

    public void setGlobalFont(String globalFont) {
        this.globalFont = globalFont;
    }

    public void setGlobalFontSize(BigInteger globalFontSize) {
        this.globalFontSize = globalFontSize;
    }

    public boolean isBlocked() {
        return this.blockLevel > 0;
    }

    public void incrementBlockLevel() {
        ++this.blockLevel;
    }

    public void decrementBlockLevel() {
        --this.blockLevel;
    }

    public void renderDocument(Document document) {
        Element body = document.body();
        Element html = body.parent();
        if (html.hasAttr("style")) {
            this.pushInlineStyle(this.getCssStyleDeclaration(html), html.isBlock());
        }
        if (body.hasAttr("style")) {
            this.pushInlineStyle(this.getCssStyleDeclaration(body), body.isBlock());
        }
        for (Node node : body.childNodes()) {
            this.renderNode(node);
        }
    }

    public void renderNode(Node node) {
        boolean isElement = node instanceof Element;
        if (isElement) {
            Element element = (Element)node;
            this.renderElement(element);
        } else if (node instanceof TextNode) {
            this.renderText(((TextNode)node).getWholeText());
        }
    }

    public void renderElement(Element element) {
        if (log.isDebugEnabled()) {
            log.info("Start rendering html tag: <{}{}>", (Object)element.normalName(), (Object)element.attributes());
        }
        if (element.tag().isFormListed() || element.tag().isFormSubmittable()) {
            return;
        }
        CSSStyleDeclarationImpl cssStyleDeclaration = this.getCssStyleDeclaration(element);
        String display = cssStyleDeclaration.getPropertyValue("display");
        if ("none".equalsIgnoreCase(display)) {
            return;
        }
        this.pushInlineStyle(cssStyleDeclaration, element.isBlock());
        ElementRenderer elementRenderer = this.rendererProvider.get(element.normalName());
        boolean blocked = false;
        if (this.renderAsBlock(element, elementRenderer)) {
            if (element.childNodeSize() == 0 && !HtmlConstants.KEEP_EMPTY_TAGS.contains(element.normalName())) {
                this.popInlineStyle();
                return;
            }
            if (!this.isBlocked()) {
                this.moveContentToNewPrevParagraph();
            }
            this.incrementBlockLevel();
            blocked = true;
            IBody container = this.getContainer();
            boolean isTableTag = "table".equals(element.normalName());
            this.adjustCursor(container, isTableTag);
            if (isTableTag) {
                this.globalCursor.push();
                XWPFTable xwpfTable = container.insertNewTbl(this.globalCursor);
                this.globalCursor.pop();
                if (this.dedupeParagraph != null && !this.numberingContext.contains(this.dedupeParagraph)) {
                    if (!this.dedupeParagraph.equals(this.getRun().getParent()) && this.isEmptyParagraph(this.dedupeParagraph)) {
                        this.removeParagraph(container, this.dedupeParagraph);
                    }
                    this.unmarkDedupe();
                }
                xwpfTable.removeRow(0);
                if (container.getPartType() == BodyType.TABLECELL && this.isShowDefaultTableBorderInTableCell()) {
                    CTTbl ctTbl = xwpfTable.getCTTbl();
                    CTTblPr tblPr = RenderUtils.getTblPr(ctTbl);
                    CTTblBorders tblBorders = RenderUtils.getTblBorders(tblPr);
                    tblBorders.addNewTop().setVal(STBorder.SINGLE);
                    tblBorders.addNewLeft().setVal(STBorder.SINGLE);
                    tblBorders.addNewBottom().setVal(STBorder.SINGLE);
                    tblBorders.addNewRight().setVal(STBorder.SINGLE);
                    tblBorders.addNewInsideH().setVal(STBorder.SINGLE);
                    tblBorders.addNewInsideV().setVal(STBorder.SINGLE);
                }
                RenderUtils.tableStyle(this, xwpfTable, cssStyleDeclaration);
            } else if (this.shouldNewParagraph(element)) {
                this.globalCursor.push();
                XWPFParagraph xwpfParagraph = this.newParagraph(container, this.globalCursor);
                this.globalCursor.pop();
                if (xwpfParagraph == null) {
                    log.warn("Can not add new paragraph for element: {}, attributes: {}", (Object)element.tagName(), (Object)element.attributes().html());
                }
                RenderUtils.paragraphStyle(this, xwpfParagraph, cssStyleDeclaration);
            } else {
                RenderUtils.paragraphStyle(this, this.dedupeParagraph, cssStyleDeclaration);
            }
        }
        if (elementRenderer != null && !elementRenderer.renderStart(element, this)) {
            this.renderElementEnd(element, this, elementRenderer, blocked);
            return;
        }
        for (Node child : element.childNodes()) {
            this.renderNode(child);
        }
        this.renderElementEnd(element, this, elementRenderer, blocked);
    }

    private boolean isEmptyParagraph(XWPFParagraph paragraph) {
        for (XWPFRun run : paragraph.getRuns()) {
            if (StringUtils.isNotBlank((CharSequence)run.text())) {
                return false;
            }
            if (run.getEmbeddedPictures().isEmpty()) continue;
            return false;
        }
        CTP ctp = paragraph.getCTP();
        return ctp.sizeOfOMathArray() == 0 && ctp.sizeOfOMathParaArray() == 0;
    }

    private void removeParagraph(IBody container, XWPFParagraph paragraph) {
        switch (container.getPartType()) {
            case CONTENTCONTROL: {
                break;
            }
            case DOCUMENT: {
                XWPFDocument xwpfDocument = (XWPFDocument)container;
                int posOfParagraph = xwpfDocument.getPosOfParagraph(paragraph);
                xwpfDocument.removeBodyElement(posOfParagraph);
                break;
            }
            case HEADER: {
                XWPFHeader xwpfHeader = (XWPFHeader)container;
                xwpfHeader.removeParagraph(paragraph);
                break;
            }
            case FOOTER: {
                XWPFFooter xwpfFooter = (XWPFFooter)container;
                xwpfFooter.removeParagraph(paragraph);
                break;
            }
            case FOOTNOTE: {
                XWPFFootnote xwpfFootnote = (XWPFFootnote)container;
                xwpfFootnote.getParagraphs().remove(paragraph);
                break;
            }
            case TABLECELL: {
                XWPFTableCell xwpfTableCell = (XWPFTableCell)container;
                xwpfTableCell.removeParagraph(xwpfTableCell.getParagraphs().indexOf(paragraph));
            }
        }
    }

    public boolean renderAsBlock(Element element) {
        return this.renderAsBlock(element, this.rendererProvider.get(element.normalName()));
    }

    private boolean renderAsBlock(Element element, ElementRenderer elementRenderer) {
        return element.isBlock() && (elementRenderer == null || elementRenderer.renderAsBlock());
    }

    private boolean shouldNewParagraph(Element element) {
        return this.dedupeParagraph == null;
    }

    private void adjustCursor(IBody container, boolean isTableTag) {
        if (this.globalCursor.getObject() instanceof CTR) {
            this.globalCursor.push();
            this.globalCursor.toParent();
        }
        this.globalCursor.push();
        if (isTableTag && this.globalCursor.toPrevSibling() && this.globalCursor.getObject() instanceof CTTbl) {
            this.globalCursor.pop();
            this.globalCursor.push();
            XWPFParagraph paragraph = this.newParagraph(container, this.globalCursor);
            this.unmarkDedupe();
            RenderUtils.paragraphStyle(this, paragraph, CSSStyleUtils.EMPTY_STYLE);
        }
        this.globalCursor.pop();
    }

    private void renderElementEnd(Element element, HtmlRenderContext context, ElementRenderer elementRenderer, boolean blocked) {
        if (elementRenderer != null) {
            elementRenderer.renderEnd(element, context);
        }
        context.popInlineStyle();
        if (blocked) {
            context.decrementBlockLevel();
        }
    }

    private void moveContentToNewPrevParagraph() {
        CTR ctr = this.getRun().getCTR();
        XmlCursor rCursor = ctr.newCursor();
        boolean hasPrevSibling = false;
        while (rCursor.toPrevSibling()) {
            XmlObject object = rCursor.getObject();
            if (object instanceof CTMarkupRange || object instanceof CTPPr) continue;
            hasPrevSibling = true;
            break;
        }
        if (!hasPrevSibling) {
            rCursor.dispose();
            return;
        }
        rCursor.toParent();
        rCursor.push();
        CTP ctp = (CTP)rCursor.getObject();
        XWPFParagraph paragraph = this.getContainer().getParagraph(ctp);
        XWPFParagraph newParagraph = this.getContainer().insertNewParagraph(rCursor);
        XmlCursor pCursor = newParagraph.getCTP().newCursor();
        pCursor.toEndToken();
        rCursor.pop();
        rCursor.toFirstChild();
        while (!ctr.equals(rCursor.getObject())) {
            XmlObject obj = rCursor.getObject();
            if (obj instanceof CTPPr) {
                rCursor.copyXml(pCursor);
                rCursor.toNextSibling();
                continue;
            }
            if (obj instanceof CTBookmark) {
                rCursor.toNextSibling();
                continue;
            }
            rCursor.moveXml(pCursor);
        }
        rCursor.dispose();
        pCursor.dispose();
        XWPFParagraphRuns runs = new XWPFParagraphRuns(paragraph);
        for (int i = runs.runCount() - ctp.getRList().size() - 1; i >= 0; --i) {
            runs.remove(i);
        }
    }

    public CSSStyleDeclarationImpl getCssStyleDeclaration(Element element) {
        String style = element.attr("style");
        CSSStyleDeclarationImpl cssStyleDeclaration = CSSStyleUtils.parse(style);
        CSSStyleUtils.split(cssStyleDeclaration);
        return cssStyleDeclaration;
    }

    public void pushCursor(XmlCursor targetCursor) {
        this.globalCursor.push();
        this.globalCursor.toCursor(targetCursor);
    }

    public boolean popCursor() {
        return this.globalCursor.pop();
    }

    public XmlObject currentCursorObject() {
        return this.globalCursor.getObject();
    }

    public void markDedupe(XWPFParagraph paragraph) {
        this.dedupeParagraph = paragraph;
    }

    public void unmarkDedupe() {
        this.dedupeParagraph = null;
    }

    private static class TextWrapper {
        private final CTText text;
        private final boolean endTrimmed;

        public TextWrapper(CTText text, boolean endTrimmed) {
            this.text = text;
            this.endTrimmed = endTrimmed;
        }

        public CTText getText() {
            return this.text;
        }

        public boolean isEndTrimmed() {
            return this.endTrimmed;
        }
    }
}

