/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import org.apache.commons.lang3.StringUtils;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.latex.LaTeXUtils;
import org.jsoup.nodes.Element;
import uk.ac.ed.ph.snuggletex.SnuggleSession;

public class LaTeXRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"latex"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        String latex = element.wholeText();
        if (StringUtils.isBlank((CharSequence)latex)) {
            return false;
        }
        SnuggleSession session = LaTeXUtils.createSession();
        LaTeXUtils.parse(session, latex);
        LaTeXUtils.renderTo(context.getClosestParagraph(), null, session);
        return false;
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }
}

