/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.latex;

import org.ddr.poi.latex.LaTeXUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;

public class TextCircledHandler
implements CommandHandler {
    private static final Logger log = LoggerFactory.getLogger(TextCircledHandler.class);

    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
        String s = builder.extractStringValue(token.getArguments()[0]);
        String replacement = LaTeXUtils.textCircledMap.get(s);
        if (replacement != null) {
            if (builder.isBuildingMathMLIsland()) {
                builder.appendMathMLTextElement(parentElement, "mi", replacement, false);
            } else {
                builder.appendXHTMLTextElement(parentElement, "span", replacement, false);
            }
        } else {
            log.warn("Text circled not found: {}", (Object)s);
        }
    }
}

