/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.auth.sign;

import com.huaweicloud.lts.producer.auth.sign.SignCache;
import com.huaweicloud.lts.producer.auth.sign.SignCacheKey;
import com.huaweicloud.lts.producer.auth.sign.SignRequest;
import com.huaweicloud.lts.producer.exception.ClientException;
import com.huaweicloud.lts.producer.util.BinaryUtil;
import com.huaweicloud.lts.producer.util.UrlEncodeUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class Sign {
    private static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    private static final String HMAC_SHA1 = "hmacsha1";
    private static final String HMAC_SHA256 = "hmacsha256";
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String HMAC_ALGORITHM = "hmacsha256";
    private static final int DERIVATION_KEY_LENGTH = 32;
    private static final int ALGORITHM_HASH_LENGTH = Sign.getHashLen("hmacsha256");
    private static final int EXPAND_CEIL = (int)Math.ceil(32.0 / (double)ALGORITHM_HASH_LENGTH);
    private static final SimpleDateFormat TIME_FORMATTER_YMD = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

    public static void signer(SignRequest request) throws ClientException {
        String time = TIME_FORMATTER_YMD.format(new Date());
        String credentialScope = Sign.buildCredentialScope(time, request.getRegion());
        String derivationKey = SignCache.getInstance().getValue(Sign.buildSignCacheKey(request, time, credentialScope));
        if (StringUtils.isEmpty((CharSequence)derivationKey)) {
            throw new ClientException("sign calc derivation key error");
        }
        String method = request.getMethod().toString();
        String canonicalUri = Sign.buildCanonicalUri(request.getUrl());
        String canonicalQueryString = Sign.buildCanonicalQueryString(request.getQueryString());
        SortedMap<String, List<String>> allSortedHeaders = Sign.getAllSortedHeaders(request);
        String canonicalHeaders = Sign.buildCanonicalHeaders(allSortedHeaders);
        String signedHeaderNames = String.join((CharSequence)";", allSortedHeaders.keySet()).toLowerCase(Locale.ROOT);
        String payloadHash = Sign.buildPayloadHash(new String(request.getBody(), StandardCharsets.UTF_8));
        String canonicalRequest = Sign.formatRequest(method, canonicalUri, canonicalQueryString, canonicalHeaders, signedHeaderNames, payloadHash);
        String hashedCanonicalRequest = BinaryUtil.toHex(BinaryUtil.sha256(canonicalRequest));
        String stringToSign = Sign.getStringToSign("V11-HMAC-SHA256", time, credentialScope, hashedCanonicalRequest);
        String signature = Sign.signature(stringToSign, derivationKey);
        String authorization = Sign.buildAuthorizationHeader(credentialScope, signature, request.getAccessKey(), signedHeaderNames);
        request.getHeaders().put("Authorization", authorization);
    }

    private static SignCacheKey buildSignCacheKey(SignRequest request, String time, String credentialScope) {
        SignCacheKey signCacheKey = new SignCacheKey();
        signCacheKey.setAccessKey(request.getAccessKey());
        signCacheKey.setSecretKey(request.getSecretKey());
        signCacheKey.setTime(time);
        signCacheKey.setCredentialScope(credentialScope);
        return signCacheKey;
    }

    private static String buildAuthorizationHeader(String credentialScope, String signature, String accessKey, String headers) {
        String credential = "Credential=" + accessKey + "/" + credentialScope;
        String signerHeaders = "SignedHeaders=" + headers;
        String signatureHeader = "Signature=" + signature;
        return "V11-HMAC-SHA256 " + credential + ", " + signerHeaders + ", " + signatureHeader;
    }

    private static String signature(String stringToSign, String derivationSecretKey) throws IllegalStateException {
        byte[] keySecret = derivationSecretKey.getBytes(StandardCharsets.UTF_8);
        byte[] signature = BinaryUtil.hmac(keySecret, stringToSign);
        return BinaryUtil.toHex(signature);
    }

    private static String getStringToSign(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    private static String formatRequest(String ... segments) {
        return String.join((CharSequence)"\n", segments);
    }

    private static String buildPayloadHash(String requestBody) throws IllegalStateException {
        if (!StringUtils.isEmpty((CharSequence)requestBody)) {
            return BinaryUtil.toHex(BinaryUtil.sha256(requestBody)).toLowerCase(Locale.ROOT);
        }
        return EMPTY_BODY_SHA256;
    }

    private static String buildCanonicalHeaders(Map<String, List<String>> headMap) {
        StringBuilder sb = new StringBuilder();
        headMap.forEach((headerName, headerValues) -> {
            for (String headValue : headerValues) {
                Sign.appendCompactedString(sb, headerName.toLowerCase(Locale.ROOT));
                sb.append(":");
                if (!StringUtils.isEmpty((CharSequence)headValue)) {
                    Sign.appendCompactedString(sb, headValue);
                }
                sb.append("\n");
            }
        });
        return sb.toString();
    }

    private static void appendCompactedString(StringBuilder destination, String source) {
        boolean previousIsWhiteSpace = false;
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (Sign.isWhiteSpace(ch)) {
                if (previousIsWhiteSpace) continue;
                destination.append(' ');
                previousIsWhiteSpace = true;
                continue;
            }
            destination.append(ch);
            previousIsWhiteSpace = false;
        }
    }

    private static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\u000b' || ch == '\r' || ch == '\f';
    }

    private static SortedMap<String, List<String>> getAllSortedHeaders(SignRequest request) throws IllegalStateException {
        String singerDate = TIME_FORMATTER.format(new Date());
        HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
        headersMap.put("X-Sdk-Date".toLowerCase(Locale.ROOT), Collections.singletonList(singerDate));
        headersMap.put("content-type", Collections.singletonList("application/json"));
        request.getHeaders().put("content-type", "application/json");
        request.getHeaders().put("X-Sdk-Date", singerDate);
        return new TreeMap<String, List<String>>(headersMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static String buildCanonicalQueryString(Map<String, List<String>> queryParam) throws IllegalStateException {
        TreeMap<String, List<String>> sorted = new TreeMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : queryParam.entrySet()) {
            String encodedParamName = UrlEncodeUtil.encode(entry.getKey(), false);
            String[] paramValues = entry.getValue().toArray(new String[0]);
            ArrayList<String> encodedValues = new ArrayList<String>(paramValues.length);
            for (String value : paramValues) {
                String encodedValue = UrlEncodeUtil.encode(value, false);
                encodedValues.add(encodedValue);
            }
            Collections.sort(encodedValues);
            sorted.put(encodedParamName, encodedValues);
        }
        return Sign.flattenQueryParameters(sorted).orElse("");
    }

    private static Optional<String> flattenQueryParameters(Map<String, List<String>> toFlatten) {
        if (toFlatten.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, List<String>> encodedQueryParameter : toFlatten.entrySet()) {
            String key = encodedQueryParameter.getKey();
            List values = Optional.ofNullable(encodedQueryParameter.getValue()).orElseGet(Collections::emptyList);
            for (String value : values) {
                if (result.length() > 0) {
                    result.append("&");
                }
                result.append(key);
                if (value == null) continue;
                result.append("=");
                result.append(value);
            }
        }
        return Optional.of(result.toString());
    }

    private static String buildCanonicalUri(String url) throws IllegalStateException {
        String[] split;
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "/";
        }
        StringBuilder canonicalUriBuilder = new StringBuilder();
        for (String urlSplit : split = url.split("/")) {
            String encodeUrl = UrlEncodeUtil.encode(urlSplit, true);
            canonicalUriBuilder.append(encodeUrl).append("/");
        }
        String canonicalUri = canonicalUriBuilder.toString();
        if (!canonicalUri.startsWith("/")) {
            canonicalUri = "/" + canonicalUri;
        }
        return canonicalUri;
    }

    public static String buildDerivationKey(String accessKey, String secretKey, String credentialScope) throws ClientException {
        if (StringUtils.isEmpty((CharSequence)accessKey) || StringUtils.isEmpty((CharSequence)secretKey)) {
            throw new ClientException("access Key or secret key is not empty");
        }
        try {
            byte[] extractKey = Sign.extract(secretKey.getBytes(UTF_8), accessKey.getBytes(UTF_8), "hmacsha256");
            byte[] derSecretKey = Sign.expand(extractKey, credentialScope.getBytes(UTF_8), "hmacsha256", 32, EXPAND_CEIL);
            if (null != derSecretKey) {
                return BinaryUtil.toHex(derSecretKey);
            }
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        return null;
    }

    private static String buildCredentialScope(String time, String region) {
        return time + "/" + region + "/" + "lts";
    }

    private static byte[] extract(byte[] ikm, byte[] salt, String hmacAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        if (salt == null || salt.length == 0) {
            salt = new byte[Sign.getHashLen(hmacAlgorithm)];
        }
        Mac mac = Mac.getInstance(hmacAlgorithm);
        mac.init(new SecretKeySpec(salt, hmacAlgorithm));
        return mac.doFinal(ikm);
    }

    private static int getHashLen(String hmacAlgorithm) {
        switch (hmacAlgorithm) {
            case "hmacsha256": {
                return 32;
            }
            case "hmacsha1": {
                return 20;
            }
        }
        return 32;
    }

    private static byte[] expand(byte[] prk, byte[] info, String hmacAlgorithm, int okmLength, int ceil) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        byte[] rawResult;
        Mac mac = Mac.getInstance(hmacAlgorithm);
        mac.init(new SecretKeySpec(prk, hmacAlgorithm));
        if (ceil == 1) {
            rawResult = Sign.expandFirst(info, mac);
        } else {
            rawResult = new byte[]{};
            byte[] temp = new byte[]{};
            for (int i = 1; i <= ceil; ++i) {
                temp = Sign.expandOnce(info, mac, temp, i);
                ByteArrayOutputStream combineBytes = new ByteArrayOutputStream();
                combineBytes.write(rawResult);
                combineBytes.write(temp);
                rawResult = combineBytes.toByteArray();
            }
        }
        return okmLength == rawResult.length ? rawResult : (byte[])(okmLength < rawResult.length ? Arrays.copyOf(rawResult, okmLength) : null);
    }

    private static byte[] expandFirst(byte[] info, Mac mac) throws IOException {
        byte[] result = new byte[info.length + 1];
        System.arraycopy(info, 0, result, 0, info.length);
        result[info.length] = 1;
        return mac.doFinal(result);
    }

    private static byte[] expandOnce(byte[] info, Mac mac, byte[] preTemp, int i) throws IOException {
        ByteArrayOutputStream hashBytes = new ByteArrayOutputStream();
        hashBytes.write(preTemp);
        hashBytes.write(info);
        hashBytes.write(i);
        return mac.doFinal(hashBytes.toByteArray());
    }
}

