/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.http;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huaweicloud.lts.producer.ProjectConfig;
import com.huaweicloud.lts.producer.auth.Credentials;
import com.huaweicloud.lts.producer.auth.DefaultCredentails;
import com.huaweicloud.lts.producer.auth.sign.Sign;
import com.huaweicloud.lts.producer.auth.sign.SignRequest;
import com.huaweicloud.lts.producer.exception.ClientException;
import com.huaweicloud.lts.producer.exception.LogException;
import com.huaweicloud.lts.producer.exception.ServiceException;
import com.huaweicloud.lts.producer.http.LogService;
import com.huaweicloud.lts.producer.http.ServiceClient;
import com.huaweicloud.lts.producer.model.http.HttpMethod;
import com.huaweicloud.lts.producer.model.http.RequestMessage;
import com.huaweicloud.lts.producer.model.http.ResponseMessage;
import com.huaweicloud.lts.producer.model.log.LogItem;
import com.huaweicloud.lts.producer.model.log.LogItems;
import com.huaweicloud.lts.producer.model.log.PutLogsRequest;
import com.huaweicloud.lts.producer.model.log.PutLogsResponse;
import com.huaweicloud.lts.producer.util.NetworkUtils;
import com.huaweicloud.lts.producer.util.Utils;
import com.huaweicloud.lts.producer.util.consts.CompressType;
import com.huaweicloud.lts.producer.util.consts.HttpMethodName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;

public class Client
implements LogService {
    protected Credentials credentials;
    private ServiceClient serviceClient;

    public Client(ProjectConfig projectConfig, ServiceClient serviceClient) {
        this.serviceClient = serviceClient;
        this.configure(new DefaultCredentails(projectConfig.getAccessKeyId(), projectConfig.getAccessKeySecret(), null, projectConfig.getProject(), projectConfig.getRegionName()));
    }

    private void configure(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getAccessId() {
        return this.credentials.getAccessKeyId();
    }

    public void setAccessId(String accessId) {
        this.credentials.setAccessKeyId(accessId);
    }

    public String getAccessKey() {
        return this.credentials.getAccessKeySecret();
    }

    public void setAccessKey(String accessKey) {
        this.credentials.setAccessKeySecret(accessKey);
    }

    public String getSecurityToken() {
        return this.credentials.getSecurityToken();
    }

    public void setSecurityToken(String securityToken) {
        this.credentials.setSecurityToken(securityToken);
    }

    public void shutdown() {
        this.serviceClient.shutdown();
    }

    private static byte[] encodeToUtf8(String source) throws LogException {
        try {
            return source.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
    }

    private static String encodeResponseBodyToUtf8String(ResponseMessage response, String requestId) throws LogException {
        byte[] body = response.GetRawBody();
        if (body == null) {
            throw new LogException("BadResponse", "The response body is null", null, requestId);
        }
        try {
            return new String(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("BadResponse", "The response is not valid utf-8 string: ", e, requestId);
        }
    }

    @Override
    public PutLogsResponse PutLogs(PutLogsRequest request) throws Exception {
        ResponseMessage response;
        block12: {
            Utils.assertArgumentNotNull(request, "request");
            String logGroupId = request.getLogGroupId();
            Utils.assertArgumentNotNullOrEmpty(logGroupId, "logGroupId");
            String logStreamId = request.getLogStreamId();
            Utils.assertArgumentNotNullOrEmpty(logStreamId, "logStreamId");
            CompressType compressType = request.GetCompressType();
            Utils.assertArgumentNotNull((Object)compressType, "compressType");
            RequestMessage requestMessage = this.getRequestMessage(request);
            response = null;
            try {
                response = this.serviceClient.sendRequest(requestMessage, "UTF-8");
                this.ExtractResponseBody(response);
                int statusCode = response.getStatusCode();
                if (statusCode == 200) break block12;
                String requestId = this.GetRequestId(response.getHeaders());
                try {
                    JSONObject object = this.parseResponseBody(response, requestId);
                    this.ErrorCheck(object, requestId, statusCode);
                }
                catch (LogException ex) {
                    ex.SetHttpCode(response.getStatusCode());
                    throw ex;
                }
            }
            catch (ClientException | ServiceException e) {
                throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return new PutLogsResponse(response.getHeaders());
    }

    private RequestMessage getRequestMessage(PutLogsRequest request) throws LogException, ClientException {
        byte[] logBytes = this.getBytes(request);
        String resourcePath = String.format("https://%s%s", this.buildLogPushEndPoint(this.credentials.getRegionName(), request.isEnableLocalTest()), Client.buildUri("/v2/internal/%s/lts/groups/%s/streams/%s/tenant/batch-contents", this.credentials.getProjectId(), request.getLogGroupId(), request.getLogStreamId()));
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setMethod(HttpMethod.POST);
        requestMessage.setRequestUrl(resourcePath);
        requestMessage.setHeaders(this.getHeaderParams());
        requestMessage.setContent(new ByteArrayInputStream(logBytes));
        requestMessage.setContentLength(logBytes.length);
        requestMessage.setAccessKey(this.getAccessId());
        requestMessage.setSecretKey(this.getAccessKey());
        requestMessage.setSignRequest(this.getSignRequest(logBytes, resourcePath));
        return requestMessage;
    }

    private SignRequest getSignRequest(byte[] logBytes, String resourcePath) throws ClientException {
        SignRequest signRequest = new SignRequest();
        signRequest.setMethod(HttpMethodName.POST.name());
        signRequest.setAccessKey(this.getAccessId());
        signRequest.setSecretKey(this.getAccessKey());
        HttpPost postMethod = new HttpPost(resourcePath);
        signRequest.setUrl(postMethod.getURI().getPath());
        signRequest.setRegion(this.credentials.getRegionName());
        signRequest.setBody(logBytes);
        signRequest.getHeaders().put("Content-Encoding", "gzip");
        Sign.signer(signRequest);
        return signRequest;
    }

    public static String buildUri(String uriTemplate, String projectId, String groupId, String streamId) {
        return String.format(uriTemplate, projectId, groupId, streamId);
    }

    private String buildLogPushEndPoint(String region, boolean enableLocalTest) {
        if (region.equals("cn-north-7")) {
            return "100.79.1.215:8102";
        }
        if (enableLocalTest) {
            return String.format("lts-access.%s.myhuaweicloud.com", region.toLowerCase(Locale.ROOT));
        }
        return String.format("lts-access.%s.myhuaweicloud.com:8102", region.toLowerCase(Locale.ROOT));
    }

    private Map<String, String> getHeaderParams() {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Content-Encoding", "gzip");
        return headerParams;
    }

    private byte[] getBytes(PutLogsRequest request) throws LogException {
        ArrayList<LogItem> datas = request.getLogItems();
        if (datas.size() > 40960) {
            throw new LogException("InvalidLogSize", "logItems' length exceeds maximum limitation : 40960 lines", "");
        }
        LogItems body = request.isLogBackSdk() ? this.getLogBackRequestBody(request) : this.getRequestBody(request);
        String bodyStr = JSONObject.toJSONString((Object)body);
        byte[] bytes = bodyStr.getBytes(StandardCharsets.UTF_8);
        if ((bytes = this.compressContent(bytes)).length > 0x3200000) {
            throw new LogException("InvalidLogSize", "logItems' size exceeds maximum limitation : 52428800 bytes", "");
        }
        return bytes;
    }

    protected LogItems getLogBackRequestBody(PutLogsRequest request) {
        ArrayList<LogItem> logItems = request.getLogItems();
        LogItem logItem = logItems.get(0);
        JSONObject labels = new JSONObject();
        labels.put("hostIP", (Object)NetworkUtils.getLocalMachineIP());
        if (StringUtils.isNotEmpty((CharSequence)request.getPathFile())) {
            labels.put("pathFile", (Object)request.getPathFile());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getAppName())) {
            labels.put("appName", (Object)request.getAppName());
        }
        logItem.setLabels(labels.toJSONString());
        logItem.setTenantProjectId(this.credentials.getProjectId());
        LogItems body = new LogItems();
        body.setLogItems(logItems);
        return body;
    }

    protected LogItems getRequestBody(PutLogsRequest request) {
        ArrayList<LogItem> logItems = request.getLogItems();
        for (LogItem logItem : request.getLogItems()) {
            logItem.setTenantProjectId(this.credentials.getProjectId());
            try {
                Map<String, String> map = new HashMap<String, String>();
                if (Objects.nonNull(logItem.getLabels())) {
                    map = (Map)JSONObject.parseObject((String)logItem.getLabels(), Map.class);
                }
                map.putIfAbsent("hostIP", NetworkUtils.getLocalMachineIP());
                logItem.setLabels(JSONObject.toJSONString(map));
            }
            catch (Exception e) {
                throw new ClientException("parse log labels error..", e);
            }
        }
        LogItems body = new LogItems();
        body.setLogItems(logItems);
        return body;
    }

    private byte[] compressContent(byte[] bytes) throws ClientException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(bytes);
        }
        catch (IOException e) {
            throw new ClientException("compress error..", e);
        }
        return out.toByteArray();
    }

    private void ExtractResponseBody(ResponseMessage response) throws LogException {
        InputStream in = response.getContent();
        if (in == null) {
            return;
        }
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        String requestId = this.GetRequestId(response.getHeaders());
        try {
            int ch;
            byte[] cache = new byte[1024];
            while ((ch = in.read(cache, 0, 1024)) != -1) {
                bytestream.write(cache, 0, ch);
            }
        }
        catch (IOException e) {
            throw new LogException("BadResponse", "Io exception happened when parse the response data : ", e, requestId);
        }
        response.SetBody(bytestream.toByteArray());
    }

    protected String GetRequestId(Map<String, String> headers) {
        return Utils.getOrEmpty(headers, "x-lts-id");
    }

    private JSONObject parseResponseBody(ResponseMessage response, String requestId) throws LogException {
        String body = Client.encodeResponseBodyToUtf8String(response, requestId);
        try {
            return JSONObject.parseObject((String)body);
        }
        catch (JSONException ex) {
            throw new LogException("BadResponse", "The response is not valid json string : " + body, ex, requestId);
        }
    }

    private void ErrorCheck(JSONObject object, String requestId, int httpCode) throws LogException {
        if (object.containsKey((Object)"errorCode")) {
            try {
                String errorCode = object.getString("errorCode");
                String errorMessage = object.getString("errorMessage");
                throw new LogException(httpCode, errorCode, errorMessage, requestId);
            }
            catch (JSONException e) {
                throw new LogException(httpCode, "InvalidErrorResponse", "Error response is not a valid error json : \n" + object.toString(), requestId);
            }
        }
        throw new LogException(httpCode, "InvalidErrorResponse", "Error response is not a valid error json : \n" + object.toString(), requestId);
    }
}

