package com.huaweicloud.lts.appender;

import java.util.Optional;

import com.huaweicloud.lts.producer.LogProducer;
import com.huaweicloud.lts.producer.Producer;
import com.huaweicloud.lts.producer.ProducerConfig;
import com.huaweicloud.lts.producer.ProjectConfig;
import com.huaweicloud.lts.producer.exception.ClientException;
import com.huaweicloud.lts.producer.util.Utils;

public class JavaSDKAppender {

    private String projectId;

    private String accessKeyId;

    private String accessKeySecret;

    private String regionName;

    private Producer producer;

    private Integer totalSizeInBytes;

    private Long maxBlockMs;

    private Integer ioThreadCount;

    private Integer batchSizeThresholdInBytes;

    private Integer batchCountThreshold;

    private Integer lingerMs;

    private Integer retries;

    private Integer maxReservedAttempts;

    private Long baseRetryBackoffMs;

    private Long maxRetryBackoffMs;

    private Integer maxSingleLogSizeInBytes;

    private Boolean enableLocalTest;

    private Boolean giveUpExtraLongSingleLog;

    private JavaSDKAppender() {
    }

    public Producer getProducer() throws ClientException {
        Utils.assertArgumentNotNullOrEmpty(accessKeyId, "accessKeyId");
        Utils.assertArgumentNotNullOrEmpty(accessKeySecret, "accessKeySecret");
        Utils.assertArgumentNotNullOrEmpty(projectId, "projectId");
        Utils.assertArgumentNotNullOrEmpty(regionName, "regionName");

        ProjectConfig projectConfig = buildProjectConfig();
        ProducerConfig producerConfig = new ProducerConfig();
        setProducerConfig(producerConfig);
        producerConfig.setProjectId(projectId);
        final Producer producer = new LogProducer(producerConfig);
        producer.putProjectConfig(projectConfig);
        return producer;
    }

    private void setProducerConfig(ProducerConfig producerConfig) {
        Optional.ofNullable(totalSizeInBytes).ifPresent(producerConfig::setTotalSizeInBytes);
        Optional.ofNullable(maxBlockMs).ifPresent(producerConfig::setMaxBlockMs);
        Optional.ofNullable(ioThreadCount).ifPresent(producerConfig::setIoThreadCount);
        Optional.ofNullable(batchSizeThresholdInBytes).ifPresent(producerConfig::setBatchSizeThresholdInBytes);
        Optional.ofNullable(batchCountThreshold).ifPresent(producerConfig::setBatchCountThreshold);
        Optional.ofNullable(lingerMs).ifPresent(producerConfig::setLingerMs);
        Optional.ofNullable(retries).ifPresent(producerConfig::setRetries);
        Optional.ofNullable(maxReservedAttempts).ifPresent(producerConfig::setMaxReservedAttempts);
        Optional.ofNullable(baseRetryBackoffMs).ifPresent(producerConfig::setBaseRetryBackoffMs);
        Optional.ofNullable(maxRetryBackoffMs).ifPresent(producerConfig::setMaxRetryBackoffMs);
        Optional.ofNullable(maxSingleLogSizeInBytes).ifPresent(producerConfig::setMaxSingleLogSizeInBytes);
        Optional.ofNullable(enableLocalTest).ifPresent(producerConfig::setEnableLocalTest);
        Optional.ofNullable(giveUpExtraLongSingleLog).ifPresent(producerConfig::setGiveUpExtraLongSingleLog);
    }

    private ProjectConfig buildProjectConfig() {
        return new ProjectConfig(projectId, regionName, accessKeyId, accessKeySecret);
    }

    public static Builder custom() {
        return new Builder();
    }

    public static final class Builder {

        private String projectId;

        private String accessKeyId;

        private String accessKeySecret;

        private String regionName;

        private Integer totalSizeInBytes;

        private Long maxBlockMs;

        private Integer ioThreadCount;

        private Integer batchSizeThresholdInBytes;

        private Integer batchCountThreshold;

        private Integer lingerMs;

        private Integer retries;

        private Integer maxReservedAttempts;

        private Long baseRetryBackoffMs;

        private Long maxRetryBackoffMs;

        private Integer maxSingleLogSizeInBytes;

        private Boolean enableLocalTest;

        private Boolean giveUpExtraLongSingleLog;

        public Builder setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setRegionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public Builder setTotalSizeInBytes(Integer totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public Builder setMaxBlockMs(Long maxBlockMs) {
            this.maxBlockMs = maxBlockMs;
            return this;
        }

        public Builder setIoThreadCount(Integer ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder setBatchSizeThresholdInBytes(Integer batchSizeThresholdInBytes) {
            this.batchSizeThresholdInBytes = batchSizeThresholdInBytes;
            return this;
        }

        public Builder setBatchCountThreshold(Integer batchCountThreshold) {
            this.batchCountThreshold = batchCountThreshold;
            return this;
        }

        public Builder setLingerMs(Integer lingerMs) {
            this.lingerMs = lingerMs;
            return this;
        }

        public Builder setRetries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public Builder setMaxReservedAttempts(Integer maxReservedAttempts) {
            this.maxReservedAttempts = maxReservedAttempts;
            return this;
        }

        public Builder setBaseRetryBackoffMs(Long baseRetryBackoffMs) {
            this.baseRetryBackoffMs = baseRetryBackoffMs;
            return this;
        }

        public Builder setMaxRetryBackoffMs(Long maxRetryBackoffMs) {
            this.maxRetryBackoffMs = maxRetryBackoffMs;
            return this;
        }

        public Builder setMaxSingleLogSizeInBytes(Integer maxSingleLogSizeInBytes) {
            this.maxSingleLogSizeInBytes = maxSingleLogSizeInBytes;
            return this;
        }

        public Builder setEnableLocalTest(Boolean enableLocalTest) {
            this.enableLocalTest = enableLocalTest;
            return this;
        }

        public Builder setGiveUpExtraLongSingleLog(Boolean giveUpExtraLongSingleLog) {
            this.giveUpExtraLongSingleLog = giveUpExtraLongSingleLog;
            return this;
        }

        public JavaSDKAppender builder() throws ClientException {
            final JavaSDKAppender javaSDKAppender = new JavaSDKAppender();
            Utils.assertArgumentNotNullOrEmpty(accessKeyId, "accessKeyId");
            Utils.assertArgumentNotNullOrEmpty(accessKeySecret, "accessKeySecret");
            Utils.assertArgumentNotNullOrEmpty(projectId, "projectId");
            Utils.assertArgumentNotNullOrEmpty(regionName, "regionName");

            javaSDKAppender.projectId = projectId;
            javaSDKAppender.accessKeyId = accessKeyId;
            javaSDKAppender.accessKeySecret = accessKeySecret;
            javaSDKAppender.regionName = regionName;
            javaSDKAppender.totalSizeInBytes = totalSizeInBytes;
            javaSDKAppender.maxBlockMs = maxBlockMs;
            javaSDKAppender.ioThreadCount = ioThreadCount;
            javaSDKAppender.batchSizeThresholdInBytes = batchSizeThresholdInBytes;
            javaSDKAppender.batchCountThreshold = batchCountThreshold;
            javaSDKAppender.lingerMs = lingerMs;
            javaSDKAppender.retries = retries;
            javaSDKAppender.maxReservedAttempts = maxReservedAttempts;
            javaSDKAppender.baseRetryBackoffMs = baseRetryBackoffMs;
            javaSDKAppender.maxRetryBackoffMs = maxRetryBackoffMs;
            javaSDKAppender.maxSingleLogSizeInBytes = maxSingleLogSizeInBytes;
            javaSDKAppender.enableLocalTest = enableLocalTest;
            javaSDKAppender.giveUpExtraLongSingleLog = giveUpExtraLongSingleLog;
            return javaSDKAppender;
        }

    }
}
