/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorexbootstater.builder;

import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.storage.MapDBStorage;
import io.github.javpower.vectorexbootstater.builder.VectoRexConditionBuilder;
import io.github.javpower.vectorexbootstater.core.FieldFunction;
import io.github.javpower.vectorexbootstater.core.VectoRexResult;
import io.github.javpower.vectorexcore.VectoRexClient;
import io.github.javpower.vectorexcore.cache.VecroRexCache;
import io.github.javpower.vectorexcore.util.GsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaQueryWrapper<T>
extends VectoRexConditionBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(LambdaQueryWrapper.class);
    private Class<T> entityType;
    private String collectionName;
    private String annsField;
    private int topK = 1;
    private List<Float> vector;
    private String textVector;
    private VectoRexClient client;

    public LambdaQueryWrapper(VectoRexClient client, String collectionName, Class<T> entityType) {
        this.client = client;
        this.collectionName = collectionName;
        this.entityType = entityType;
    }

    public LambdaQueryWrapper<T> topK(Integer topK) {
        this.setTopK(topK);
        return this;
    }

    public LambdaQueryWrapper<T> vector(String annsField, List<Float> vector) {
        this.annsField = annsField;
        this.vector = vector;
        return this;
    }

    public LambdaQueryWrapper<T> vector(FieldFunction<T, ?> annsField, List<Float> vector) {
        this.annsField = annsField.getFieldName(annsField);
        this.vector = vector;
        return this;
    }

    public LambdaQueryWrapper<T> textVector(String annsField, String textVector) {
        this.annsField = annsField;
        this.textVector = textVector;
        return this;
    }

    public LambdaQueryWrapper<T> textVector(FieldFunction<T, ?> annsField, String textVector) {
        this.annsField = annsField.getFieldName(annsField);
        this.textVector = textVector;
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> eq(String fieldName, Object value) {
        super.eq(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> eq(FieldFunction<T, ?> fieldName, Object value) {
        super.eq(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> ne(String fieldName, Object value) {
        super.ne(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> ne(FieldFunction<T, ?> fieldName, Object value) {
        super.ne(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> gt(String fieldName, Comparable value) {
        super.gt(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> gt(FieldFunction<T, Comparable> fieldName, Comparable value) {
        super.gt(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> ge(String fieldName, Comparable value) {
        super.ge(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> ge(FieldFunction<T, Comparable> fieldName, Comparable value) {
        super.ge(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> lt(String fieldName, Comparable value) {
        super.lt(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> lt(FieldFunction<T, Comparable> fieldName, Comparable value) {
        super.lt(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> le(String fieldName, Comparable value) {
        super.le(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> le(FieldFunction<T, Comparable> fieldName, Comparable value) {
        super.le(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> between(String fieldName, Comparable start, Comparable end) {
        super.between(fieldName, start, end);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> between(FieldFunction<T, Comparable> fieldName, Comparable start, Comparable end) {
        super.between(fieldName, start, end);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> in(String fieldName, List<?> values) {
        super.in(fieldName, values);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> in(FieldFunction<T, ?> fieldName, List<?> values) {
        super.in(fieldName, values);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> like(String fieldName, String value) {
        super.like(fieldName, value);
        return this;
    }

    @Override
    public LambdaQueryWrapper<T> like(FieldFunction<T, String> fieldName, String value) {
        super.like(fieldName, value);
        return this;
    }

    public List<VectoRexResult<T>> query() {
        MapDBStorage store = this.client.getStore(this.collectionName);
        List results = this.vector != null ? (this.filters.getOperations().size() > 0 ? store.search(this.annsField, this.vector, this.topK, this.filters) : store.search(this.annsField, this.vector, this.topK, null)) : (this.textVector != null ? (this.filters.getOperations().size() > 0 ? store.search(this.annsField, this.textVector, this.topK, this.filters) : store.search(this.annsField, this.textVector, this.topK, null)) : store.query(this.filters));
        Map toFiled = (Map)VecroRexCache.toField.get(this.entityType.getName());
        return results.stream().map(result -> {
            VectoRexResult<Object> vectoRexResult = new VectoRexResult<Object>();
            Float score = result.getScore();
            DbData data = result.getData();
            Map metadata = data.getMetadata();
            HashMap properties = new HashMap();
            for (Map.Entry stringObjectEntry : metadata.entrySet()) {
                if (!toFiled.containsKey(stringObjectEntry.getKey())) continue;
                properties.put(toFiled.get(stringObjectEntry.getKey()), stringObjectEntry.getValue());
            }
            Object o = GsonUtil.convertMapToType(properties, this.entityType);
            vectoRexResult.setEntity(o);
            vectoRexResult.setScore(score);
            return vectoRexResult;
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaQueryWrapper)) {
            return false;
        }
        LambdaQueryWrapper other = (LambdaQueryWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTopK() != other.getTopK()) {
            return false;
        }
        Class<T> this$entityType = this.getEntityType();
        Class<T> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$annsField = this.getAnnsField();
        String other$annsField = other.getAnnsField();
        if (this$annsField == null ? other$annsField != null : !this$annsField.equals(other$annsField)) {
            return false;
        }
        List<Float> this$vector = this.getVector();
        List<Float> other$vector = other.getVector();
        if (this$vector == null ? other$vector != null : !((Object)this$vector).equals(other$vector)) {
            return false;
        }
        String this$textVector = this.getTextVector();
        String other$textVector = other.getTextVector();
        if (this$textVector == null ? other$textVector != null : !this$textVector.equals(other$textVector)) {
            return false;
        }
        VectoRexClient this$client = this.getClient();
        VectoRexClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LambdaQueryWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getTopK();
        Class<T> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $annsField = this.getAnnsField();
        result = result * 59 + ($annsField == null ? 43 : $annsField.hashCode());
        List<Float> $vector = this.getVector();
        result = result * 59 + ($vector == null ? 43 : ((Object)$vector).hashCode());
        String $textVector = this.getTextVector();
        result = result * 59 + ($textVector == null ? 43 : $textVector.hashCode());
        VectoRexClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getAnnsField() {
        return this.annsField;
    }

    public int getTopK() {
        return this.topK;
    }

    public List<Float> getVector() {
        return this.vector;
    }

    public String getTextVector() {
        return this.textVector;
    }

    public VectoRexClient getClient() {
        return this.client;
    }

    public void setEntityType(Class<T> entityType) {
        this.entityType = entityType;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setAnnsField(String annsField) {
        this.annsField = annsField;
    }

    public void setTopK(int topK) {
        this.topK = topK;
    }

    public void setVector(List<Float> vector) {
        this.vector = vector;
    }

    public void setTextVector(String textVector) {
        this.textVector = textVector;
    }

    public void setClient(VectoRexClient client) {
        this.client = client;
    }

    public String toString() {
        return "LambdaQueryWrapper(entityType=" + this.getEntityType() + ", collectionName=" + this.getCollectionName() + ", annsField=" + this.getAnnsField() + ", topK=" + this.getTopK() + ", vector=" + this.getVector() + ", textVector=" + this.getTextVector() + ", client=" + this.getClient() + ")";
    }
}

