/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorexbootstater.mapper;

import com.google.common.collect.Lists;
import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.core.VectorData;
import io.github.javpower.vectorex.keynote.model.VectorFiled;
import io.github.javpower.vectorexbootstater.builder.LambdaQueryWrapper;
import io.github.javpower.vectorexbootstater.core.VectoRexResult;
import io.github.javpower.vectorexcore.VectoRexClient;
import io.github.javpower.vectorexcore.annotation.VectoRexCollection;
import io.github.javpower.vectorexcore.cache.VecroRexCache;
import io.github.javpower.vectorexcore.entity.KeyValue;
import io.github.javpower.vectorexcore.entity.ScalarField;
import io.github.javpower.vectorexcore.entity.VectoRexEntity;
import io.github.javpower.vectorexcore.util.GsonUtil;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseVectoRexMapper<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseVectoRexMapper.class);

    public abstract VectoRexClient getClient();

    public Class<T> getEntityType() {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return (Class)type;
    }

    private VectoRexCollection getCollectionAnnotation(Class<T> entityType) {
        VectoRexCollection collectionAnnotation = entityType.getAnnotation(VectoRexCollection.class);
        if (collectionAnnotation == null) {
            throw new IllegalStateException("Entity type " + entityType.getName() + " is not annotated with @VectoRexCollection.");
        }
        return collectionAnnotation;
    }

    private VectoRexEntity getVectoRexEntity(Class<T> entityType) {
        return (VectoRexEntity)VecroRexCache.rexCache.get(entityType.getName());
    }

    private String getPrimaryKey(Class<T> entityType) {
        return (String)VecroRexCache.primaryKey.get(entityType.getName());
    }

    private Map<String, String> getToFieldMap(Class<T> entityType) {
        return (Map)VecroRexCache.toField.get(entityType.getName());
    }

    public LambdaQueryWrapper<T> queryWrapper() {
        Class<T> entityType = this.getEntityType();
        VectoRexCollection collectionAnnotation = this.getCollectionAnnotation(entityType);
        return new LambdaQueryWrapper<T>(this.getClient(), collectionAnnotation.name(), entityType);
    }

    public VectoRexResult getById(Serializable id) {
        Class<T> entityType = this.getEntityType();
        VectoRexCollection collectionAnnotation = this.getCollectionAnnotation(entityType);
        DbData data = this.getClient().getStore(collectionAnnotation.name()).get(id.toString());
        VectoRexResult<Object> result = new VectoRexResult<Object>();
        Map metadata = data.getMetadata();
        HashMap properties = new HashMap();
        Map<String, String> toField = this.getToFieldMap(entityType);
        for (Map.Entry entry : metadata.entrySet()) {
            if (!toField.containsKey(entry.getKey())) continue;
            properties.put(toField.get(entry.getKey()), entry.getValue());
        }
        Object entity = GsonUtil.convertMapToType(properties, entityType);
        result.setScore(Float.valueOf(0.0f));
        result.setEntity(entity);
        return result;
    }

    public void removeById(Serializable id) {
        Class<T> entityType = this.getEntityType();
        VectoRexCollection collectionAnnotation = this.getCollectionAnnotation(entityType);
        this.getClient().getStore(collectionAnnotation.name()).delete(id.toString());
    }

    private List<DbData> convertEntitiesToDbData(Collection<T> entities, Class<T> entityType) {
        VectoRexEntity vectoRex = this.getVectoRexEntity(entityType);
        String primaryKey = this.getPrimaryKey(entityType);
        List vectorFields = vectoRex.getVectorFileds();
        List scalarFields = vectoRex.getScalarFields();
        ArrayList<DbData> dbDatas = new ArrayList<DbData>();
        for (T entity : entities) {
            Object valueObject;
            DbData dbData = new DbData();
            Map data = GsonUtil.fromJsonToMap((String)GsonUtil.toJson(entity));
            String id = BaseVectoRexMapper.convertToIntegerString(data.get(primaryKey));
            ArrayList<VectorData> vectorData = new ArrayList<VectorData>();
            HashMap metadata = new HashMap();
            for (KeyValue vectorField : vectorFields) {
                List valueList;
                valueObject = data.get(vectorField.getKey());
                metadata.put(((VectorFiled)vectorField.getValue()).getName(), valueObject);
                if (!(valueObject instanceof List) || (valueList = (List)valueObject).isEmpty()) continue;
                float[] valueArray = new float[valueList.size()];
                for (int i = 0; i < valueList.size(); ++i) {
                    Object element = valueList.get(i);
                    if (!(element instanceof Number)) {
                        throw new IllegalArgumentException("List element is not a Number: " + element);
                    }
                    valueArray[i] = ((Number)element).floatValue();
                }
                VectorData vectorData1 = new VectorData(id, valueArray);
                vectorData1.setName(((VectorFiled)vectorField.getValue()).getName());
                vectorData.add(vectorData1);
            }
            for (KeyValue scalarField : scalarFields) {
                valueObject = data.get(scalarField.getKey());
                metadata.put(((ScalarField)scalarField.getValue()).getName(), valueObject);
            }
            dbData.setId(id);
            dbData.setVectorFiled(vectorData);
            dbData.setMetadata(metadata);
            dbDatas.add(dbData);
        }
        return dbDatas;
    }

    public void insert(Collection<T> entities) {
        Class<T> entityType = this.getEntityType();
        VectoRexCollection collectionAnnotation = this.getCollectionAnnotation(entityType);
        List<DbData> dbDatas = this.convertEntitiesToDbData(entities, entityType);
        this.getClient().getStore(collectionAnnotation.name()).saveAll(dbDatas);
    }

    public void insert(T entities) {
        this.insert((T)Lists.newArrayList((Object[])new Object[]{entities}));
    }

    public void updateById(T entities) {
        this.updateById(Lists.newArrayList((Object[])new Object[]{entities}));
    }

    public void updateById(Collection<T> entities) {
        Class<T> entityType = this.getEntityType();
        VectoRexCollection collectionAnnotation = this.getCollectionAnnotation(entityType);
        List<DbData> dbDatas = this.convertEntitiesToDbData(entities, entityType);
        for (DbData dbData : dbDatas) {
            this.getClient().getStore(collectionAnnotation.name()).update(dbData);
        }
    }

    private static String convertToIntegerString(Object value) {
        if (value instanceof Number) {
            BigDecimal bd = BigDecimal.valueOf(((Number)value).doubleValue());
            return bd.toBigInteger().toString();
        }
        return value.toString();
    }
}

