/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime;

import io.github.kawamuray.wasmtime.Caller;
import io.github.kawamuray.wasmtime.Disposable;
import io.github.kawamuray.wasmtime.FuncRegistry;
import io.github.kawamuray.wasmtime.FuncType;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.Val;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Func
implements Disposable {
    private static final Logger log = LoggerFactory.getLogger(Func.class);
    private static final Val[] EMPTY_VALS = new Val[0];
    static final FuncRegistry registry = new FuncRegistry();
    private final long innerPtr;

    public <T> Func(Store<T> store, FuncType fnType, Handler<T> func) {
        this(Func.create(store, fnType, func));
    }

    private static <T> long create(Store<T> store, FuncType fnType, Handler<T> handler) {
        int index = registry.acquire(handler);
        log.debug("New trampoline {} of type {}", (Object)index, (Object)fnType);
        return Func.newFunc(store.innerPtr(), fnType, index);
    }

    public <T> Val[] call(Store<T> store, Val ... args) {
        return this.nativeCall(store.innerPtr(), args);
    }

    public <T> List<Val> call(Store<T> store, Collection<Val> args) {
        return Arrays.asList(this.call(store, args.toArray(EMPTY_VALS)));
    }

    private static <T> void invokeTrampoline(long callerPtr, int index, Val[] params, Val[] results) {
        Handler fn;
        if (log.isDebugEnabled()) {
            log.debug("Trampoline {} invoked with params={}, results={}", new Object[]{index, params, results});
        }
        if ((fn = registry.lookup(index)) == null) {
            throw new IllegalStateException("no trampoline function associated to index: " + index);
        }
        try (Caller caller = new Caller(callerPtr);){
            fn.call(caller, params, results);
        }
    }

    private static void dropTrampoline(int index) {
        log.debug("Dropping trampoline {}", (Object)index);
        registry.drop(index);
    }

    @Override
    public native void dispose();

    private static native long newFunc(long var0, FuncType var2, int var3);

    private native Val[] nativeCall(long var1, Val[] var3);

    Func(long innerPtr) {
        this.innerPtr = innerPtr;
    }

    long innerPtr() {
        return this.innerPtr;
    }

    @FunctionalInterface
    public static interface Handler<T> {
        public void call(Caller<T> var1, Val[] var2, Val[] var3);
    }
}

