/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime;

import io.github.kawamuray.wasmtime.FuncType;
import io.github.kawamuray.wasmtime.GlobalType;
import io.github.kawamuray.wasmtime.MemoryType;
import io.github.kawamuray.wasmtime.TableType;

public class ImportType {
    private final Type type;
    private final Object typeObj;
    private final String module;
    private final String name;

    private void ensureType(Type expected) {
        if (this.type != expected) {
            throw new RuntimeException(String.format("ImportType expected to have type %s but is actually %s", new Object[]{expected, this.type}));
        }
    }

    public FuncType func() {
        this.ensureType(Type.FUNC);
        return (FuncType)this.typeObj;
    }

    public GlobalType global() {
        this.ensureType(Type.GLOBAL);
        return (GlobalType)this.typeObj;
    }

    public MemoryType memory() {
        this.ensureType(Type.MEMORY);
        return (MemoryType)this.typeObj;
    }

    public TableType table() {
        this.ensureType(Type.TABLE);
        return (TableType)this.typeObj;
    }

    ImportType(Type type, Object typeObj, String module, String name) {
        this.type = type;
        this.typeObj = typeObj;
        this.module = module;
        this.name = name;
    }

    public Type type() {
        return this.type;
    }

    Object typeObj() {
        return this.typeObj;
    }

    public String module() {
        return this.module;
    }

    public String name() {
        return this.name;
    }

    public static enum Type {
        FUNC,
        GLOBAL,
        TABLE,
        MEMORY;

    }
}

