/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime;

import io.github.kawamuray.wasmtime.Disposable;
import io.github.kawamuray.wasmtime.MemoryType;
import io.github.kawamuray.wasmtime.Store;
import java.nio.ByteBuffer;

public class Memory
implements Disposable {
    private long innerPtr;

    public <T> Memory(Store<T> store, MemoryType type) {
        this(Memory.newMemory(store.innerPtr(), type.minimum(), type.maximum(), type.is64()));
    }

    public <T> ByteBuffer buffer(Store<T> store) {
        return this.nativeBuffer(store.innerPtr());
    }

    public <T> long dataSize(Store<T> store) {
        return this.nativeDataSize(store.innerPtr());
    }

    public <T> int size(Store<T> store) {
        return this.nativeSize(store.innerPtr());
    }

    public <T> int grow(Store<T> store, long deltaPages) {
        return this.nativeGrow(store.innerPtr(), deltaPages);
    }

    @Override
    public native void dispose();

    private static native long newMemory(long var0, long var2, long var4, boolean var6);

    private native ByteBuffer nativeBuffer(long var1);

    private native long nativeDataSize(long var1);

    private native int nativeSize(long var1);

    private native int nativeGrow(long var1, long var3);

    public Memory(long innerPtr) {
        this.innerPtr = innerPtr;
    }
}

