/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime;

public final class Val {
    private final Type type;
    private final Object value;

    public static Val fromI32(int val) {
        return new Val(Type.I32, val);
    }

    public static Val fromI64(long val) {
        return new Val(Type.I64, val);
    }

    public static Val fromF32(float val) {
        return new Val(Type.F32, Float.valueOf(val));
    }

    public static Val fromF64(double val) {
        return new Val(Type.F64, val);
    }

    private void ensureType(Type expected) {
        if (this.type != expected) {
            throw new RuntimeException(String.format("value expected to have type %s but is actually %s", new Object[]{expected, this.type}));
        }
    }

    public int i32() {
        this.ensureType(Type.I32);
        return (Integer)this.value;
    }

    public long i64() {
        this.ensureType(Type.I64);
        return (Long)this.value;
    }

    public float f32() {
        this.ensureType(Type.F32);
        return ((Float)this.value).floatValue();
    }

    public double f64() {
        this.ensureType(Type.F64);
        return (Double)this.value;
    }

    public Val(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Val)) {
            return false;
        }
        Val other = (Val)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "Val(type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ")";
    }

    public static enum Type {
        I32,
        I64,
        F32,
        F64,
        EXTERN_REF,
        FUNC_REF,
        V128;

    }
}

