/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime;

import io.github.kawamuray.wasmtime.Trap;

public class WasmFunctionError
extends RuntimeException {
    public WasmFunctionError(String message) {
        super(message);
    }

    public static class TrapError
    extends WasmFunctionError {
        private final Trap trap;

        TrapError(Trap trap) {
            super("wasm trap: " + (Object)((Object)trap));
            this.trap = trap;
        }

        public Trap trap() {
            return this.trap;
        }
    }

    public static class I32ExitError
    extends WasmFunctionError {
        private final int exitCode;

        public I32ExitError(int exitCode) {
            super("exit code: " + exitCode);
            this.exitCode = exitCode;
        }

        public int exitCode() {
            return this.exitCode;
        }
    }
}

